/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import org.springframework.util.Assert;

public class Jdbcs {
    public static DbType getDbType(String jdbcUrl) {
        Assert.hasText((String)jdbcUrl, (String)"Error: The jabcUrl is Null, Cannot read database type");
        String url = jdbcUrl.toLowerCase();
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (url.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        LogUtils.warn((String)("The jabcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!"), (Object[])new Object[0]);
        return DbType.OTHER;
    }

    public static enum DbType {
        MYSQL("mysql", "MySqL\u6570\u636e\u5e93"),
        ORACLE("oracle", "Oracle11g\u53ca\u4ee5\u4e0b\u6570\u636e\u5e93\uff08\u9ad8\u7248\u672c\u63a8\u8350\u4f7f\u7528ORACLE_NEW\uff09"),
        OTHER("other", "\u5176\u4ed6\u6570\u636e\u5e93");

        private final String db;
        private final String desc;

        private DbType(String db, String desc) {
            this.db = db;
            this.desc = desc;
        }

        public String getDb() {
            return this.db;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

