/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.datasource.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.RSA;

public class RSAUtil {
    private static final KeyPair keyPair = KeyUtil.generateKeyPair((String)"RSA");

    public static String generatePublicKey() {
        return Base64.encode((byte[])keyPair.getPublic().getEncoded());
    }

    public static String generatePrivateKey() {
        return Base64.encode((byte[])keyPair.getPrivate().getEncoded());
    }

    public static String encryptByPrivateKey(String content, String privateKey) {
        RSA rsa = new RSA(privateKey);
        return rsa.encryptHex(content, KeyType.PrivateKey);
    }

    public static String encryptByPublicKey(String content, String publicKey, String privateKey) {
        RSA rsa = new RSA(privateKey.replace(" ", "+"), publicKey.replace(" ", "+"));
        return rsa.encryptBase64(content, KeyType.PublicKey);
    }

    public static String decryptByPrivateKey(String encryptContent, String privateKey) {
        RSA rsa = new RSA(privateKey);
        return rsa.decryptStr(encryptContent, KeyType.PrivateKey, StandardCharsets.UTF_8);
    }

    public static String decryptByPublicKey(String encryptContent, String publicKey) {
        RSA rsa = new RSA(null, publicKey);
        return rsa.decryptStr(encryptContent, KeyType.PublicKey, StandardCharsets.UTF_8);
    }
}

