/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.base.repository;

import jakarta.persistence.EntityManagerFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class BaseDao {
    protected final EntityManagerFactory emf;

    public BaseDao(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public Session getSession() {
        return ((SessionFactory)this.emf.unwrap(SessionFactory.class)).getCurrentSession();
    }

    public Session getNewSession() {
        return ((SessionFactory)this.emf.unwrap(SessionFactory.class)).openSession();
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void close() {
        this.getSession().close();
    }

    public void save(Object obj) {
        this.getSession().persist(obj);
    }

    public void update(Object obj) {
        this.getSession().merge(obj);
    }

    public void saveOrUpdate(Object obj) {
        this.getSession().persist(obj);
    }

    public void delete(Serializable id, Class<?> clazz) {
        this.getSession().remove(this.get(id, clazz));
    }

    public void delete(Object obj) {
        this.getSession().remove(obj);
    }

    public int executeUpdate(String hql, Map<String, ?> props) {
        return this.createHQLQuery(hql, props).executeUpdate();
    }

    public int executeUpdate(String hql, Object ... props) {
        return this.createHQLQuery(hql, props).executeUpdate();
    }

    public int executeUpdateSQL(String sql, Map<String, ?> props) {
        return this.createSQLQuery(sql, props).executeUpdate();
    }

    public int executeUpdateSQL(String sql, Object ... props) {
        return this.createSQLQuery(sql, props).executeUpdate();
    }

    public Object get(Serializable id, Class<?> clazz) {
        return this.getSession().get(clazz, (Object)id);
    }

    public <T> T getById(Serializable id, Class<T> clazz) {
        return (T)this.getSession().get(clazz, (Object)id);
    }

    public void batchSave(List<?> models, int num) {
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            this.save(models.get(i));
            if (i % num != 0 && i != size - 1) continue;
            this.flush();
            this.clear();
        }
    }

    public void batchSaveOrUpdate(List<?> models, int num) {
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            this.saveOrUpdate(models.get(i));
            if (i % num != 0 && i != size - 1) continue;
            this.flush();
            this.clear();
        }
    }

    public void batchUpdate(List<?> models, int num) {
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            this.update(models.get(i));
            if (i % num != 0 && i != size - 1) continue;
            this.flush();
            this.clear();
        }
    }

    public Object findUnique(String hql, Map<String, ?> props) {
        return this.createHQLQuery(hql, props).uniqueResult();
    }

    public Object findUnique(String hql, Object ... props) {
        return this.createHQLQuery(hql, props).uniqueResult();
    }

    public Object findSQLUnique(String sql, Map<String, ?> props) {
        return this.createSQLQuery(sql, props).uniqueResult();
    }

    public Object findSQLUnique(String sql, Object ... props) {
        return this.createSQLQuery(sql, props).uniqueResult();
    }

    public List<?> findByHQL(String hql, Map<String, ?> props) {
        return this.createHQLQuery(hql, props).list();
    }

    public List<?> findByHQL(String hql, Object ... props) {
        return this.createHQLQuery(hql, props).list();
    }

    public List<?> findByHQLLimit(String hql, int limit, Map<String, ?> props) {
        return this.createHQLQuery(hql, props).setMaxResults(limit).list();
    }

    public List<?> findByHQLLimit(String hql, int limit, Object ... props) {
        return this.createHQLQuery(hql, props).setMaxResults(limit).list();
    }

    public PageModel findPage(int pageNum, int pageSize, String hql, Map<String, ?> props) {
        long total = ((Number)this.findUnique(BaseDao.toCount(hql), props)).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createHQLQuery(hql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findPage(int pageNum, int pageSize, String hql, Object ... props) {
        long total = ((Number)this.findUnique(BaseDao.toCount(hql), props)).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createHQLQuery(hql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findPage_(int pageNum, int pageSize, String hql, String countHql, Map<String, ?> props) {
        long total = ((Number)this.findUnique(countHql, props)).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createHQLQuery(hql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findPage_(int pageNum, int pageSize, String hql, String countHql, Object ... props) {
        long total = ((Number)this.findUnique(countHql, props)).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createHQLQuery(hql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public List<Map<String, Object>> findSQLMap(String sql, Map<String, ?> props) {
        return this.createSQLQuery(sql, props).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
    }

    public List<Map<String, Object>> findSQLMap(String sql, Object ... props) {
        return this.createSQLQuery(sql, props).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
    }

    public List<?> findSQLEntity(String sql, String[] names, Class<?> ... clazz) {
        Query query = this.createSQLQuery(sql, new Object[0]);
        if (clazz != null) {
            int size = clazz.length;
            for (int i = 0; i < size; ++i) {
                query.setParameter(names[i], clazz[i]);
            }
        }
        return query.list();
    }

    public List<?> findSQLEntity(String sql, Map<String, ?> props, String[] names, Class<?> ... clazz) {
        Query query = this.createSQLQuery(sql, props);
        if (clazz != null) {
            int size = clazz.length;
            for (int i = 0; i < size; ++i) {
                query.setParameter(names[i], clazz[i]);
            }
        }
        return query.list();
    }

    public PageModel findSQLPage(int pageNum, int pageSize, String sql, Map<String, ?> props) {
        long total = ((Number)this.createSQLQuery(BaseDao.toCount(sql), props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findSQLPageNoCountTotal(int pageNum, int pageSize, String sql, Map<String, ?> props) {
        List rows = Collections.emptyList();
        Query query = this.createSQLQuery(sql, props);
        query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        rows = query.list();
        return new PageModel(0L, rows);
    }

    public Long getCountBySql(String sql, Object ... parms) {
        return ((Number)this.createSQLQuery(sql, parms).uniqueResult()).longValue();
    }

    public PageModel findSQLPage(int pageNum, int pageSize, String sql, Object ... props) {
        long total = ((Number)this.createSQLQuery(BaseDao.toCount(sql), props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findSQLPageEntity(int pageNum, int pageSize, String sql, Map<String, ?> props, String[] names, Class<?> ... clazz) {
        long total = ((Number)this.createSQLQuery(BaseDao.toCount(sql), props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            if (clazz != null) {
                int size = clazz.length;
                for (int i = 0; i < size; ++i) {
                    query.setParameter(names[i], clazz[i]);
                }
            }
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findSQLPage_(int pageNum, int pageSize, String sql, String countSql, Map<String, ?> props) {
        long total = ((Number)this.createSQLQuery(countSql, props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findSQLPage_(int pageNum, int pageSize, String sql, String countSql, Object ... props) {
        long total = ((Number)this.createSQLQuery(countSql, props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize).setResultListTransformer((ResultListTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    public PageModel findSQLPageEntity_(int pageNum, int pageSize, String sql, String countSql, Map<String, ?> props, String[] names, Class<?> ... clazz) {
        long total = ((Number)this.createSQLQuery(countSql, props).uniqueResult()).longValue();
        List rows = Collections.emptyList();
        if (total != 0L) {
            Query query = this.createSQLQuery(sql, props);
            query.setFirstResult(BaseDao.getFirst(pageNum, pageSize)).setMaxResults(pageSize);
            if (clazz != null) {
                int size = clazz.length;
                for (int i = 0; i < size; ++i) {
                    query.setParameter(names[i], clazz[i]);
                }
            }
            rows = query.list();
        }
        return new PageModel(total, rows);
    }

    private Query createHQLQuery(String queryString, Map<String, ?> values) {
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    private Query createSQLQuery(String queryString, Map<String, ?> values) {
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    private Query createHQLQuery(String queryString, Object ... values) {
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            int size = values.length;
            for (int i = 0; i < size; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    private Query createSQLQuery(String queryString, Object ... values) {
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            int size = values.length;
            for (int i = 0; i < size; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    private static String toCount(String sql) {
        String countSql = sql.trim().replaceFirst("(?i)^.*?from", "select count(*) from").replaceAll("(?i)fetch", "").replaceFirst("(?i)order\\s+by((\\s*,)?\\s*\\S+\\s*((asc)|(desc))?)*$", "");
        return countSql;
    }

    private static int getFirst(int page, int max) {
        return (page - 1) * max;
    }

    public static class PageModel {
        private long total;
        private List<?> rows;

        public PageModel(long total, List<?> rows) {
            this.total = total;
            this.rows = rows;
        }

        public long getTotal() {
            return this.total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public List<?> getRows() {
            return this.rows;
        }

        public void setRows(List<?> rows) {
            this.rows = rows;
        }
    }
}

