/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.base.repository;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.jpa.base.entity.JpaSuperEntity;
import jakarta.persistence.QueryHint;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
public interface JpaInterfaceSuperRepository<E extends JpaSuperEntity<ID>, ID extends Serializable>
extends JpaRepository<E, ID>,
JpaSpecificationExecutor<E>,
QuerydslPredicateExecutor<E>,
RevisionRepository<E, ID, Long>,
QueryRewriter {
    default public String rewrite(String query, Sort sort) {
        LogUtils.info((String)"query rewriter sql : {}", (Object[])new Object[]{query});
        return query;
    }

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<E> findAll();

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<E> findAll(Sort var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Optional<E> findOne(Specification<E> var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<E> findAll(Specification<E> var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Page<E> findAll(Specification<E> var1, Pageable var2);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<E> findAll(Specification<E> var1, Sort var2);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public long count(Specification<E> var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Page<E> findAll(Pageable var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Optional<E> findById(ID var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public long count();

    @Transactional
    public void deleteById(ID var1);

    @Query(value="UPDATE #{#entityName} table SET table.deleted = 'DELETED' WHERE table.id = ?1")
    @Transactional(rollbackFor={Exception.class})
    @Modifying
    public void logicDelete(ID var1);

    @Transactional(rollbackFor={Exception.class})
    default public void logicDelete(E entity) {
        this.logicDelete((E)((JpaSuperEntity)entity).getId());
    }

    @Transactional(rollbackFor={Exception.class})
    default public void logicDelete(Iterable<? extends E> entities) {
        entities.forEach(entity -> this.logicDelete((E)entity.getId()));
    }

    @Modifying
    @Transactional(rollbackFor={Exception.class})
    @Query(value="UPDATE #{#entityName} table SET table.deleted = 'DELETED' ")
    public void logicDeleteAll();
}

