/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.base.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.taotao.boot.cache.redis.model.CacheKey;
import com.taotao.boot.cache.redis.model.CacheKeyBuilder;
import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.data.jpa.base.entity.JpaSuperEntity;
import com.taotao.boot.data.jpa.base.repository.JpaClassSuperRepository;
import com.taotao.boot.data.jpa.base.repository.JpaInterfaceSuperRepository;
import com.taotao.boot.data.jpa.base.service.JpaSuperCacheService;
import com.taotao.boot.data.jpa.base.service.impl.JpaSuperServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import org.dromara.hutool.core.collection.CollUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.transaction.annotation.Transactional;

public abstract class JpaSuperCacheServiceImpl<CR extends JpaClassSuperRepository<T, I>, IR extends JpaInterfaceSuperRepository<T, I>, T extends JpaSuperEntity<I>, I extends Serializable>
extends JpaSuperServiceImpl<CR, IR, T, I>
implements JpaSuperCacheService<T, I> {
    @Autowired
    protected RedisRepository redisRepository;
    protected static final int MAX_BATCH_KEY_SIZE = 20;

    protected abstract CacheKeyBuilder cacheKeyBuilder();

    @Override
    @Transactional(readOnly=true)
    public T getByIdCache(I id) {
        CacheKey cacheKey = this.cacheKeyBuilder().key(new Object[]{id});
        return (T)((JpaSuperEntity)this.redisRepository.get(cacheKey, k -> (JpaSuperEntity)this.cr().getReferenceById((Object)id), new boolean[0]));
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByIds(@NonNull Collection<I> ids, Function<Collection<I>, Collection<T>> loader) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List<CacheKey> keys = ids.stream().map(arg_0 -> JpaSuperCacheServiceImpl.lambda$findByIds$1(this.cacheKeyBuilder(), arg_0)).toList();
        List partitionKeys = Lists.partition(keys, (int)20);
        ArrayList valueList = new ArrayList();
        ArrayList keysList = Lists.newArrayList(ids);
        LinkedHashSet missedKeys = Sets.newLinkedHashSet();
        ArrayList<JpaSuperEntity> allList = new ArrayList<JpaSuperEntity>();
        for (int i = 0; i < valueList.size(); ++i) {
            JpaSuperEntity v = (JpaSuperEntity)valueList.get(i);
            Serializable k = (Serializable)keysList.get(i);
            if (v == null) {
                missedKeys.add(k);
                continue;
            }
            allList.add(v);
        }
        if (CollUtil.isNotEmpty((Collection)missedKeys)) {
            Collection<JpaSuperEntity> missList = loader.apply(missedKeys);
            missList.forEach(this::setCache);
            allList.addAll(missList);
        }
        return allList;
    }

    @Override
    @Transactional(readOnly=true)
    public T getByKey(CacheKey key, Function<CacheKey, I> loader) {
        Serializable id = (Serializable)this.redisRepository.get(key, loader, new boolean[0]);
        return id == null ? null : (T)this.getByIdCache(id);
    }

    @Override
    public void refreshCache() {
        this.cr().findAll().forEach(this::setCache);
    }

    @Override
    public void clearCache() {
        this.cr().findAll().forEach(this::delCache);
    }

    protected void delCache(Serializable ... ids) {
        this.delCache((T)Arrays.asList(ids));
    }

    protected void delCache(Collection<? extends Serializable> idList) {
        CacheKey[] keys = (CacheKey[])idList.stream().map(id -> this.cacheKeyBuilder().key(new Object[]{id})).toArray(CacheKey[]::new);
        this.redisRepository.del(keys);
    }

    protected void delCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.redisRepository.del(new CacheKey[]{key});
        }
    }

    protected void setCache(T model) {
        Object id = this.getId(model);
        if (id != null) {
            CacheKey key = this.cacheKeyBuilder().key(new Object[]{id});
            this.redisRepository.set(key, model, new boolean[0]);
        }
    }

    protected Object getId(T model) {
        if (model instanceof JpaSuperEntity) {
            return ((JpaSuperEntity)model).getId();
        }
        return null;
    }

    private static /* synthetic */ CacheKey lambda$findByIds$1(CacheKeyBuilder rec$, Object xva$0) {
        return rec$.key(new Object[]{xva$0});
    }
}

