/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.builder;

import com.taotao.boot.common.constant.SymbolConstants;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.utils.bean.BeanUtils;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.common.utils.common.StringUtils;
import com.taotao.boot.common.utils.convert.ConvertUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class JpaCriteriaBuilder<T> {
    private Integer pageNumber;
    private Integer pageSize;
    private final List<Sort.Order> rawSortList = new ArrayList<Sort.Order>();
    private Specification<T> specification = Specification.where(null);
    public static final Integer FIFTEEN = 15;

    private JpaCriteriaBuilder() {
    }

    public static <T> JpaCriteriaBuilder<T> Builder() {
        return new JpaCriteriaBuilder<T>();
    }

    public <V> JpaCriteriaBuilder<T> autoBuilder(JpaCriteriaBuilder builder, @NotNull V entity) {
        Field[] fields;
        if (Objects.isNull(entity)) {
            throw new BusinessException("\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String pageSize = "pageSize";
        String pageIndex = "pageIndex";
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            field.setAccessible(Boolean.TRUE);
            try {
                Object value = field.get(entity);
                if (!StringUtils.isNullAndSpaceOrEmpty((Object)value)) continue;
                if (pageIndex.equals(field.getName())) {
                    builder = builder.page(ConvertUtils.convertInt((Object)value));
                    continue;
                }
                if (pageSize.equals(field.getName())) {
                    builder = builder.size(ConvertUtils.convertInt((Object)value));
                    continue;
                }
                builder = builder.equal(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                LogUtils.error((Throwable)e);
            }
        }
        return builder;
    }

    public <V> JpaCriteriaBuilder<T> autoBuilder(JpaCriteriaBuilder builder, @NotNull V entity, List<String> ignoreFields) {
        List[] groupFields = new List[]{};
        return this.autoBuilder(builder, entity, ignoreFields, groupFields);
    }

    public <V> JpaCriteriaBuilder<T> autoBuilder(JpaCriteriaBuilder builder, @NotNull V entity, List<String> ... groupFields) {
        return this.autoBuilder(builder, entity, (List<String>)CollectionUtils.toList((Object[])new String[0]), groupFields);
    }

    public <V> JpaCriteriaBuilder<T> autoBuilder(JpaCriteriaBuilder<T> builder, @NotNull V entity, List<String> ignoreFields, List<String> ... groupFields) {
        if (Objects.isNull(entity)) {
            throw new BusinessException("\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ignoreFields == null) {
            ignoreFields = CollectionUtils.toList((Object[])new String[0]);
        }
        if (groupFields == null) {
            groupFields = new List[ConvertUtils.ZERO.intValue()];
        }
        if (CollectionUtils.isEmpty((Object[])groupFields) || CollectionUtils.isEmpty((Object[])groupFields)) {
            return this.autoBuilder(builder, entity);
        }
        String pageSize = "pageSize";
        String pageIndex = "pageIndex";
        Integer size = null;
        Integer index = null;
        Field[] fields = entity.getClass().getDeclaredFields();
        ArrayList<JpaCriteriaBuilder<T>> groupFieldsList = new ArrayList<JpaCriteriaBuilder<T>>();
        for (int i = ConvertUtils.ZERO.intValue(); i < groupFields.length; ++i) {
            List<String> groupField = groupFields[i];
            List fieldList = Arrays.stream(fields).filter(groupField::equals).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fieldList)) continue;
            JpaCriteriaBuilder<T> criteria = (JpaCriteriaBuilder<T>)BeanUtils.copyProperties(builder, JpaCriteriaBuilder.class);
            for (Field field : fieldList) {
                field.setAccessible(Boolean.TRUE);
                String fieldName = field.getName();
                if (ignoreFields.contains(fieldName)) continue;
                try {
                    Object value = field.get(entity);
                    if (!StringUtils.isNullAndSpaceOrEmpty((Object)value)) continue;
                    if (pageIndex.equals(field.getName())) {
                        index = ConvertUtils.convertInt((Object)value);
                        continue;
                    }
                    if (pageSize.equals(field.getName())) {
                        size = ConvertUtils.convertInt((Object)value);
                        continue;
                    }
                    criteria = criteria.equal(field.getName(), value);
                }
                catch (IllegalAccessException e) {
                    LogUtils.error((Throwable)e);
                }
            }
            groupFieldsList.add(criteria);
        }
        JpaCriteriaBuilder<T> result = builder.or(groupFieldsList.toArray(new JpaCriteriaBuilder[ConvertUtils.ZERO.intValue()]));
        result.page(index).size(size);
        return result;
    }

    public <V> JpaCriteriaBuilder<T> equal(@NotNull String field, @NotNull V value) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get(field), value));
        }
        return this;
    }

    public <V> JpaCriteriaBuilder<T> like(@NotNull String field, @NotNull V value) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> {
                String pattern = SymbolConstants.PERCENT + String.valueOf(value) + SymbolConstants.PERCENT;
                return criteriaBuilder.like((Expression)root.get(field), pattern);
            });
        }
        return this;
    }

    public <V> JpaCriteriaBuilder<T> in(@NotNull String field, @NotNull List<V> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> root.get(field).in((Collection)values));
        }
        return this;
    }

    public <V extends Comparable<? super V>> JpaCriteriaBuilder<T> greaterThan(@NotNull String field, @NotNull V value) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.greaterThan((Expression)root.get(field), value));
        }
        return this;
    }

    public <V extends Comparable<? super V>> JpaCriteriaBuilder<T> greaterThanOrEqualTo(@NotNull String field, @NotNull V value) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(field), value));
        }
        return this;
    }

    public <V extends Comparable<? super V>> JpaCriteriaBuilder<T> lessThan(@NotNull String field, @NotNull V value) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.lessThan((Expression)root.get(field), value));
        }
        return this;
    }

    public <V extends Comparable<? super V>> JpaCriteriaBuilder<T> between(@NotNull String field, @NotNull V from, V to) {
        if (from != null && to != null) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.between((Expression)root.get(field), from, to));
        }
        return this;
    }

    public JpaCriteriaBuilder<T> isNull(String field) {
        this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.isNull((Expression)root.get(field)));
        return this;
    }

    public JpaCriteriaBuilder<T> isNotNull(String field) {
        this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.isNotNull((Expression)root.get(field)));
        return this;
    }

    public <X> JpaCriteriaBuilder<T> joinEqual(String joinField, @NotNull String field, @NotNull Object value, JoinType joinType) {
        if (this.isValidValue(value)) {
            this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> {
                Join join = root.join(joinField, joinType);
                return criteriaBuilder.equal((Expression)join.get(field), value);
            });
        }
        return this;
    }

    public JpaCriteriaBuilder<T> add(Function<Root<T>, Predicate> condition) {
        this.specification = this.specification.and((Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = (Predicate)condition.apply(root);
            return criteriaBuilder.and(new Predicate[]{predicate});
        });
        return this;
    }

    public JpaCriteriaBuilder<T> or(JpaCriteriaBuilder<T> ... otherBuilder) {
        Specification combinedSpecification = Specification.where(this.specification);
        for (JpaCriteriaBuilder<T> builder : otherBuilder) {
            combinedSpecification = combinedSpecification.or(builder.build());
        }
        this.specification = combinedSpecification;
        return this;
    }

    public JpaCriteriaBuilder<T> page(int page) {
        this.pageNumber = page;
        return this;
    }

    public JpaCriteriaBuilder<T> size(int size) {
        this.pageSize = size;
        return this;
    }

    public JpaCriteriaBuilder<T> orderBy(@NotNull String field, @NotNull Sort.Direction direction) {
        if (direction != null) {
            this.rawSortList.add(Sort.Order.by((String)field).with(direction));
        }
        return this;
    }

    public Pageable toPageable() {
        if (CollectionUtils.isEmpty(this.rawSortList)) {
            throw new BusinessException("\u5206\u9875\u67e5\u8be2\u5fc5\u987b\u6307\u5b9a\u6392\u5e8f\u6761\u4ef6");
        }
        return PageRequest.of((int)Objects.requireNonNullElse(this.pageNumber, ConvertUtils.ZERO), (int)Objects.requireNonNullElse(this.pageSize, FIFTEEN), (Sort)Sort.by(this.rawSortList));
    }

    public Specification<T> build() {
        return (Specification & Serializable)(root, query, cb) -> {
            if (!this.rawSortList.isEmpty()) {
                List orders = this.rawSortList.stream().map(sortOrder -> {
                    Path path = root.get(sortOrder.getProperty());
                    return sortOrder.getDirection().isAscending() ? cb.asc((Expression)path) : cb.desc((Expression)path);
                }).collect(Collectors.toList());
                query.orderBy(orders);
            }
            return this.specification.toPredicate(root, query, cb);
        };
    }

    private <V> boolean isValidValue(V value) {
        if (value instanceof String) {
            return Objects.nonNull(value) && !((String)value).trim().isEmpty();
        }
        return Objects.nonNull(value);
    }
}

