/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.jpa.bean.AuditorBean;
import com.taotao.boot.data.jpa.configuration.IgnoreNullMergeEventListener;
import com.taotao.boot.data.jpa.event.AnAggregateRoot;
import com.taotao.boot.data.jpa.extend.JpaExtendRepositoryFactoryBean;
import com.taotao.boot.data.jpa.properties.HibernateProperties;
import com.taotao.boot.data.jpa.properties.TenantProperties;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.hibernate.event.internal.DefaultMergeEventListener;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.envers.repository.config.EnableEnversRepositories;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration
@EnableJpaAuditing
@EnableEnversRepositories
@EnableTransactionManagement
@Import(value={AnAggregateRoot.class})
@EnableJpaRepositories(basePackages={"com.taotao.cloud.*.biz.repository.inf", "com.taotao.cloud.*.infrastructure.persistent.repository", "com.taotao.cloud.*.infrastructure.persistent.*.repository"}, repositoryFactoryBeanClass=JpaExtendRepositoryFactoryBean.class)
@EnableConfigurationProperties(value={TenantProperties.class, HibernateProperties.class, JpaProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.data.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class HibernateAutoConfiguration
implements InitializingBean {
    private final JpaProperties jpaProperties;
    private final HibernateProperties hibernateProperties;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HibernateAutoConfiguration.class, (String)"taotao-boot-starter-data-jpa", (String[])new String[0]);
    }

    public HibernateAutoConfiguration(JpaProperties jpaProperties, HibernateProperties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
        this.jpaProperties = jpaProperties;
    }

    @Bean
    public AuditorBean auditorBean() {
        return new AuditorBean();
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setShowSql(this.hibernateProperties.isShowSql());
        hibernateJpaVendorAdapter.setGenerateDdl(this.hibernateProperties.isGenerateDdl());
        hibernateJpaVendorAdapter.setDatabase(this.hibernateProperties.getDatabase());
        return hibernateJpaVendorAdapter;
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer() {
        return newJpaProperties -> {
            newJpaProperties.put("hibernate.format_sql", this.hibernateProperties.isFormatSql());
            newJpaProperties.put("hibernate.highlight_sql", this.hibernateProperties.isHighlightSql());
            newJpaProperties.put("hibernate.implicit_naming_strategy", this.hibernateProperties.getImplicitNamingStrategy());
            newJpaProperties.put("hibernate.physical_naming_strategy", this.hibernateProperties.getPhysicalNamingStrategy());
            newJpaProperties.put("hibernate.dialect", this.hibernateProperties.getDialect());
            newJpaProperties.put("hibernate.jdbc.time_zone", this.hibernateProperties.getTimeZone());
            newJpaProperties.put("hibernate.session_factory.statement_inspector", this.hibernateProperties.getStatementInspector());
            newJpaProperties.put("hibernate.session_factory.interceptor", this.hibernateProperties.getInterceptor());
        };
    }

    @Configuration
    public static class HibernateListenerConfigurer {
        @PersistenceUnit
        private EntityManagerFactory entityManagerFactory;

        @PostConstruct
        protected void init() {
            SessionFactoryImpl sessionFactory = (SessionFactoryImpl)this.entityManagerFactory.unwrap(SessionFactoryImpl.class);
            EventListenerRegistry registry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
            EventListenerGroup eventListenerGroup = registry.getEventListenerGroup(EventType.MERGE);
            Iterable listeners = eventListenerGroup.listeners();
            for (MergeEventListener listener : listeners) {
                if (!(listener instanceof DefaultMergeEventListener)) continue;
                DefaultMergeEventListener oldListener = (DefaultMergeEventListener)listener;
                CallbackRegistry callbackRegistry = (CallbackRegistry)FieldUtil.getFieldValue((Object)oldListener, (String)"callbackRegistry");
                IgnoreNullMergeEventListener newListener = new IgnoreNullMergeEventListener(callbackRegistry);
                registry.getEventListenerGroup(EventType.MERGE).clearListeners();
                registry.getEventListenerGroup(EventType.MERGE).prependListener((Object)newListener);
                oldListener = null;
            }
        }
    }
}

