/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.ext.doris;

import com.taotao.boot.data.datasource.ext.doris.DorisDataSourceConfiguration;
import jakarta.persistence.EntityManager;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration(after={DorisDataSourceConfiguration.class})
@ConditionalOnBean(value={DataSource.class}, name={"dorisDruidDataSource"})
@ConditionalOnProperty(name={"spring.datasource.doris.enabled"}, havingValue="true")
@EnableTransactionManagement
@EnableJpaRepositories(entityManagerFactoryRef="dorisEntityManagerFactory", transactionManagerRef="dorisTransactionManager", basePackages={"com.taotao.cloud.*.biz.doris.repository"})
public class DorisJpaConfiguration {
    private final DataSource dataSource;
    private final JpaProperties jpaProperties;
    private final HibernateProperties hibernateProperties;

    public DorisJpaConfiguration(@Autowired @Qualifier(value="dorisDruidDataSource") DataSource dataSource, JpaProperties jpaProperties, HibernateProperties hibernateProperties) {
        this.dataSource = dataSource;
        this.jpaProperties = jpaProperties;
        this.hibernateProperties = hibernateProperties;
    }

    @Bean(name={"dorisEntityManager"})
    public EntityManager dorisEntityManager(EntityManagerFactoryBuilder builder) {
        return this.dorisEntityManagerFactory(builder).getObject().createEntityManager();
    }

    @Bean(name={"dorisEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean dorisEntityManagerFactory(EntityManagerFactoryBuilder builder) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.dataSource);
        em.setPersistenceUnitName("dorisPersistenceUnit");
        em.setPackagesToScan(new String[]{"com.taotao.cloud.*.biz.doris.entity"});
        em.setJpaPropertyMap(this.getHibernateProperties());
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setShowSql(true);
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return em;
    }

    @Bean(name={"dorisTransactionManager"})
    public PlatformTransactionManager dorisTransactionManager(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(this.dorisEntityManagerFactory(builder).getObject());
    }

    private Map<String, Object> getHibernateProperties() {
        return this.hibernateProperties.determineHibernateProperties(this.jpaProperties.getProperties(), new HibernateSettings());
    }
}

