/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.jpa.extend.ExpressionQueryResolverStrategy;
import com.taotao.boot.data.jpa.extend.MyQuery;
import com.taotao.boot.data.jpa.extend.QueryResolveResult;
import com.taotao.boot.data.jpa.extend.RemovePageSortParametersParameterAccessor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;

public abstract class AbstractJpaExtendQuery
extends AbstractJpaQuery {
    protected DeclaredQuery declaredQuery;
    protected EntityManager em;

    public AbstractJpaExtendQuery(JpaQueryMethod method, EntityManager em, MyQuery myQuery) {
        super(method, em);
        if (QueryUtils.hasConstructorExpression((String)myQuery.value())) {
            throw new InvalidJpaQueryMethodException("SQL Cannot has constructor expression , SQL: " + myQuery.value());
        }
        this.declaredQuery = new DeclaredQuery(myQuery.value(), myQuery.countQuery(), StringUtils.isEmpty((CharSequence)myQuery.countProjection()) ? null : myQuery.countProjection(), myQuery.nativeQuery(), myQuery.expressionQuery());
        this.em = em;
    }

    protected Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        Pageable pageable;
        JpaParameters parameters = this.getQueryMethod().getParameters();
        Object[] values = accessor.getValues();
        RemovePageSortParametersParameterAccessor removePageSortParametersParameterAccessor = new RemovePageSortParametersParameterAccessor((Parameters<?, ?>)parameters, values);
        QueryResolveResult resolveResult = ExpressionQueryResolverStrategy.resolve(this.declaredQuery.getQueryString(), this.declaredQuery.isExpressionQuery(), parameters, removePageSortParametersParameterAccessor.getRemovePageSortParameters());
        String nativeQuery = resolveResult.getAfterParseSQL();
        LogUtils.info((String)"MyExtendJpaQuery before sql :{} resolve sql:{}", (Object[])new Object[]{this.declaredQuery.getQueryString(), nativeQuery});
        String sortedQueryString = QueryUtils.applySorting((String)nativeQuery, (Sort)removePageSortParametersParameterAccessor.getSort(), (String)QueryUtils.detectAlias((String)nativeQuery));
        Query query = this.createJpaQuery(sortedQueryString);
        resolveResult.setQueryParams(query);
        if (parameters.hasPageableParameter() && (pageable = (Pageable)values[parameters.getPageableIndex()]) != null) {
            query.setFirstResult((int)pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        return query;
    }

    protected abstract Query createJpaQuery(String var1);

    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        JpaParameters parameters = this.getQueryMethod().getParameters();
        Object[] values = accessor.getValues();
        RemovePageSortParametersParameterAccessor removePageSortParametersParameterAccessor = new RemovePageSortParametersParameterAccessor((Parameters<?, ?>)parameters, values);
        String countQueryString = StringUtils.isEmpty((CharSequence)this.declaredQuery.getCountQueryString()) ? this.declaredQuery.getQueryString() : this.declaredQuery.getCountQueryString();
        QueryResolveResult resolveResult = ExpressionQueryResolverStrategy.resolve(countQueryString, this.declaredQuery.isExpressionQuery(), parameters, removePageSortParametersParameterAccessor.getRemovePageSortParameters());
        String queryString = resolveResult.getAfterParseSQL();
        Query query = this.createJpaCountQuery(queryString);
        resolveResult.setQueryParams(query);
        return query;
    }

    protected abstract Query createJpaCountQuery(String var1);

    public static class DeclaredQuery {
        private String queryString;
        private String countQueryString;
        private String countProjection;
        private boolean nativeQuery;
        private boolean expressionQuery;

        public DeclaredQuery() {
        }

        public DeclaredQuery(String queryString, String countQueryString, String countProjection, boolean nativeQuery, boolean expressionQuery) {
            this.queryString = queryString;
            this.countQueryString = countQueryString;
            this.countProjection = countProjection;
            this.nativeQuery = nativeQuery;
            this.expressionQuery = expressionQuery;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public String getCountQueryString() {
            return this.countQueryString;
        }

        public void setCountQueryString(String countQueryString) {
            this.countQueryString = countQueryString;
        }

        public String getCountProjection() {
            return this.countProjection;
        }

        public void setCountProjection(String countProjection) {
            this.countProjection = countProjection;
        }

        public boolean isNativeQuery() {
            return this.nativeQuery;
        }

        public void setNativeQuery(boolean nativeQuery) {
            this.nativeQuery = nativeQuery;
        }

        public boolean isExpressionQuery() {
            return this.expressionQuery;
        }

        public void setExpressionQuery(boolean expressionQuery) {
            this.expressionQuery = expressionQuery;
        }
    }
}

