/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.data.jpa.extend.JpaExtendQueryUtils;
import com.taotao.boot.data.jpa.extend.QueryResolveResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.data.jpa.repository.query.JpaParameters;

public final class ExpressionQueryResolverStrategy {
    public static QueryResolveResult resolve(String queryString, boolean expressionQuery, JpaParameters parameters, Object[] values) {
        Optional<ExpressionQueryResolverEnum> resolverEnumOptional = Arrays.stream(ExpressionQueryResolverEnum.values()).filter(item -> item.match(queryString, expressionQuery)).findFirst();
        if (!resolverEnumOptional.isPresent()) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230SQL\u89e3\u6790\u7b56\u7565");
        }
        return resolverEnumOptional.get().resolve(queryString, parameters, values);
    }

    static enum ExpressionQueryResolverEnum implements ExpressionQueryResolver
    {
        EmptyExpressionQueryResolver{

            @Override
            public boolean match(String queryString, boolean expressionQuery) {
                return !expressionQuery;
            }

            @Override
            public QueryResolveResult resolve(String queryString, JpaParameters parameters, Object[] values) {
                Matcher positionExpressionParameter = POSITION_EXPRESSION_PARAMETER.matcher(queryString);
                boolean positionParam = false;
                if (positionExpressionParameter.find()) {
                    positionParam = true;
                }
                return new QueryResolveResult.EmptyQueryResolveResult(queryString, positionParam, parameters, values);
            }
        }
        ,
        PlaceholderPositionExpressionQueryResolver{

            @Override
            public boolean match(String queryString, boolean expressionQuery) {
                if (!expressionQuery) {
                    return false;
                }
                Matcher expressionParameter = PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString);
                Matcher positionExpressionParameter = POSITION_EXPRESSION_PARAMETER.matcher(queryString);
                return expressionParameter.find() && positionExpressionParameter.find();
            }

            @Override
            public QueryResolveResult resolve(String queryString, JpaParameters parameters, Object[] values) {
                Matcher expressionParameter = PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString);
                ArrayList<Integer> removeParamIndex = new ArrayList<Integer>();
                while (expressionParameter.find()) {
                    String parameter = expressionParameter.group(1);
                    queryString = super.positionParameterProcessor(queryString, values, removeParamIndex, parameter);
                }
                String afterParseSQL = queryString.replace("?{", "").replace("}", "");
                return new QueryResolveResult.PositionExpressionQueryResolveResult(afterParseSQL, removeParamIndex, JpaExtendQueryUtils.toPositionMap(values));
            }
        }
        ,
        PlaceholderNameExpressionQueryResolver{

            @Override
            public boolean match(String queryString, boolean expressionQuery) {
                if (!expressionQuery) {
                    return false;
                }
                Matcher expressionParameter = PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString);
                Matcher nameExpressionParameter = NAME_EXPRESSION_PARAMETER.matcher(queryString);
                return expressionParameter.find() && nameExpressionParameter.find();
            }

            @Override
            public QueryResolveResult resolve(String queryString, JpaParameters parameters, Object[] values) {
                Map<String, Object> allQueryParams = JpaExtendQueryUtils.getParams(parameters, values);
                ArrayList<String> removeParams = new ArrayList<String>();
                Matcher expressionParameter = PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString);
                while (expressionParameter.find()) {
                    String matchExpression = expressionParameter.group();
                    queryString = super.nameParameterProcessor(queryString, allQueryParams, removeParams, matchExpression);
                }
                String afterParseSQL = queryString.replace("?{", "").replace("}", "");
                return new QueryResolveResult.NameExpressionQueryResolveResult(afterParseSQL, removeParams, allQueryParams);
            }
        }
        ,
        PositionExpressionQueryResolver{

            @Override
            public boolean match(String queryString, boolean expressionQuery) {
                if (!expressionQuery) {
                    return false;
                }
                return !PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString).find() && NO_PLACEHOLDER_POSITION_EXPRESSION_PARAMETER.matcher(queryString).find();
            }

            @Override
            public QueryResolveResult resolve(String queryString, JpaParameters parameters, Object[] values) {
                Matcher expressionParameter = NO_PLACEHOLDER_POSITION_EXPRESSION_PARAMETER.matcher(queryString);
                ArrayList<Integer> removeParamIndex = new ArrayList<Integer>();
                while (expressionParameter.find()) {
                    String parameter = expressionParameter.group();
                    queryString = super.positionParameterProcessor(queryString, values, removeParamIndex, parameter);
                }
                return new QueryResolveResult.PositionExpressionQueryResolveResult(queryString, removeParamIndex, JpaExtendQueryUtils.toPositionMap(values));
            }
        }
        ,
        NameExpressionQueryResolver{

            @Override
            public boolean match(String queryString, boolean expressionQuery) {
                if (!expressionQuery) {
                    return false;
                }
                return !PLACEHOLDER_EXPRESSION_PARAMETER.matcher(queryString).find() && NO_PLACEHOLDER_NAME_EXPRESSION_PARAMETER.matcher(queryString).find();
            }

            @Override
            public QueryResolveResult resolve(String queryString, JpaParameters parameters, Object[] values) {
                Map<String, Object> allQueryParams = JpaExtendQueryUtils.getParams(parameters, values);
                ArrayList<String> removeParams = new ArrayList<String>();
                Matcher expressionParameter = NO_PLACEHOLDER_NAME_EXPRESSION_PARAMETER.matcher(queryString);
                while (expressionParameter.find()) {
                    String matchExpression = expressionParameter.group();
                    queryString = super.nameParameterProcessor(queryString, allQueryParams, removeParams, matchExpression);
                }
                return new QueryResolveResult.NameExpressionQueryResolveResult(queryString, removeParams, allQueryParams);
            }
        };

    }

    static interface ExpressionQueryResolver {
        public static final String PLACEHOLDER_PREFIX = "?{";
        public static final String PLACEHOLDER_SUFFIX = "}";
        public static final String BLANK_STR = "";
        public static final Pattern PLACEHOLDER_EXPRESSION_PARAMETER = Pattern.compile("\\?\\{(.+?)\\}");
        public static final Pattern POSITION_EXPRESSION_PARAMETER = Pattern.compile("\\?[1-9+]");
        public static final Pattern NAME_EXPRESSION_PARAMETER = Pattern.compile(":[a-zA-Z0-9]+");
        public static final Pattern NO_PLACEHOLDER_POSITION_EXPRESSION_PARAMETER = Pattern.compile("(where|WHERE|and|AND|or|OR)\\s+[a-zA-Z._]+\\s+=\\s+\\?[1-9+]");
        public static final Pattern NO_PLACEHOLDER_NAME_EXPRESSION_PARAMETER = Pattern.compile("(where|WHERE|and|AND|or|OR)\\s+[a-zA-Z._]+\\s+=\\s+:[a-zA-Z0-9]+");

        public boolean match(String var1, boolean var2);

        public QueryResolveResult resolve(String var1, JpaParameters var2, Object[] var3);

        default public String nameParameterProcessor(String queryString, Map<String, Object> allQueryParams, List<String> removeParams, String matchExpression) {
            String parameterName;
            Object parameterValue;
            Matcher parameterExpressionMatcher = NAME_EXPRESSION_PARAMETER.matcher(matchExpression);
            if (parameterExpressionMatcher.find() && (parameterValue = allQueryParams.get(parameterName = parameterExpressionMatcher.group().replace(":", BLANK_STR))) == null) {
                queryString = queryString.replace(matchExpression, BLANK_STR);
                removeParams.add(parameterName);
            }
            if (removeParams.size() == allQueryParams.size()) {
                queryString = StrUtil.replace((CharSequence)queryString, (CharSequence)"where", (CharSequence)BLANK_STR, (boolean)true);
            }
            return queryString;
        }

        default public String positionParameterProcessor(String queryString, Object[] values, List<Integer> removeParamIndex, String parameterExpression) {
            Matcher positionExpressionMatcher = POSITION_EXPRESSION_PARAMETER.matcher(parameterExpression);
            if (positionExpressionMatcher.find()) {
                String paramExpression = positionExpressionMatcher.group();
                Integer index = Integer.valueOf(paramExpression.replace("?", BLANK_STR));
                Integer position = index - 1;
                Object paramValue = values[position];
                if (paramValue == null) {
                    queryString = queryString.replace(parameterExpression, BLANK_STR);
                    removeParamIndex.add(position);
                } else {
                    int count = removeParamIndex.stream().filter(item -> index > item).collect(Collectors.toList()).size();
                    Integer newIndex = index - count;
                    String newParameter = parameterExpression.replace("?" + index, "?" + newIndex);
                    queryString = queryString.replace(parameterExpression, newParameter);
                }
            }
            if (removeParamIndex.size() == values.length) {
                queryString = StrUtil.replace((CharSequence)queryString, (CharSequence)"where", (CharSequence)BLANK_STR, (boolean)true);
            }
            return queryString;
        }
    }
}

