/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.data.jpa.extend.MyQuery;
import com.taotao.boot.data.jpa.extend.NativeJpaExtendQuery;
import com.taotao.boot.data.jpa.extend.SimpleJpaExtendQuery;
import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;

public class JpaExtendQueryLookupStrategy
implements QueryLookupStrategy {
    private final EntityManager entityManager;
    private QueryLookupStrategy jpaQueryLookupStrategy;
    private JpaQueryMethodFactory queryMethodFactory;

    public JpaExtendQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, QueryRewriterProvider queryRewriterProvider, EscapeCharacter escape) {
        this.jpaQueryLookupStrategy = JpaQueryLookupStrategy.create((EntityManager)em, (JpaQueryMethodFactory)queryMethodFactory, (QueryLookupStrategy.Key)key, (QueryMethodEvaluationContextProvider)evaluationContextProvider, (QueryRewriterProvider)queryRewriterProvider, (EscapeCharacter)escape);
        this.entityManager = em;
        this.queryMethodFactory = queryMethodFactory;
    }

    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, QueryRewriterProvider queryRewriterProvider, EscapeCharacter escape) {
        return new JpaExtendQueryLookupStrategy(em, queryMethodFactory, key, evaluationContextProvider, queryRewriterProvider, escape);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        if (method.getAnnotation(MyQuery.class) == null) {
            return this.jpaQueryLookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
        }
        MyQuery myQuery = method.getAnnotation(MyQuery.class);
        JpaQueryMethod jpaQueryMethod = this.queryMethodFactory.build(method, metadata, factory);
        return myQuery.nativeQuery() ? new NativeJpaExtendQuery(jpaQueryMethod, this.entityManager, myQuery) : new SimpleJpaExtendQuery(jpaQueryMethod, this.entityManager, myQuery);
    }
}

