/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.repository.query.Parameter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JpaExtendQueryUtils {
    private static final Pattern ORDERBY_PATTERN = Pattern.compile("order\\s+by.+?$", 34);

    private static String wrapCountQuery(String query) {
        return "select count(*) from (" + query + ") as temp";
    }

    private static String cleanOrderBy(String query) {
        Matcher matcher = ORDERBY_PATTERN.matcher(query);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String part = matcher.group(i);
            if (JpaExtendQueryUtils.canClean(part)) {
                matcher.appendReplacement(sb, "");
            } else {
                matcher.appendReplacement(sb, part);
            }
            ++i;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static boolean canClean(String orderByPart) {
        return orderByPart != null && (!orderByPart.contains(")") || StringUtils.countOccurrencesOf((String)orderByPart, (String)")") == StringUtils.countOccurrencesOf((String)orderByPart, (String)"("));
    }

    public static Map<String, Object> getParams(JpaParameters parameters, Object[] values) {
        Map<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < parameters.getNumberOfParameters(); ++i) {
            Parameter parameter;
            Object value;
            block4: {
                try {
                    value = values[i];
                    parameter = parameters.getParameter(i);
                    if (value != null) break block4;
                    params.put(parameter.getName().orElse(null), null);
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (value == null || !parameter.isBindable() || !JpaExtendQueryUtils.isValidValue(value)) continue;
            Class<?> clz = value.getClass();
            if (clz.isPrimitive() || String.class.isAssignableFrom(clz) || Number.class.isAssignableFrom(clz) || clz.isArray() || Collection.class.isAssignableFrom(clz) || clz.isEnum()) {
                params.put(parameter.getName().orElse(null), value);
                continue;
            }
            params = JpaExtendQueryUtils.toParams(value);
        }
        return params;
    }

    public static Map<Integer, Object> toPositionMap(Object[] values) {
        HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
        int position = 0;
        for (Object paramValue : values) {
            if (paramValue == null) {
                valueMap.put(position, null);
            } else {
                if (!JpaExtendQueryUtils.isValidValue(paramValue)) continue;
                Class<?> clz = paramValue.getClass();
                if (clz.isPrimitive() || String.class.isAssignableFrom(clz) || Number.class.isAssignableFrom(clz) || clz.isArray() || Collection.class.isAssignableFrom(clz) || clz.isEnum()) {
                    valueMap.put(position, paramValue);
                } else {
                    throw new RuntimeException("position param cannot Object");
                }
            }
            ++position;
        }
        return valueMap;
    }

    public static Map<String, Object> toParams(Object beanOrMap) {
        Map<String, Object> params = beanOrMap instanceof Map ? (Map<String, Object>)beanOrMap : JpaExtendQueryUtils.objectToMap(beanOrMap);
        return params;
    }

    public static boolean isValidValue(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof Collection) || !CollectionUtils.isEmpty((Collection)((Collection)object));
    }

    public static Map<String, Object> objectToMap(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            HashMap<String, Object> description = new HashMap<String, Object>();
            if (bean instanceof DynaBean) {
                DynaProperty[] descriptors;
                for (DynaProperty descriptor : descriptors = ((DynaBean)DynaBean.class.cast(bean)).getDynaClass().getDynaProperties()) {
                    String name = descriptor.getName();
                    description.put(name, BeanUtils.getProperty((Object)bean, (String)name));
                }
            } else {
                PropertyDescriptor[] descriptors;
                for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) {
                    String name = descriptor.getName();
                    if (PropertyUtils.getReadMethod((PropertyDescriptor)descriptor) == null) continue;
                    description.put(name, PropertyUtils.getNestedProperty((Object)bean, (String)name));
                }
            }
            return description;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static String toCountQuery(String query) {
        return JpaExtendQueryUtils.wrapCountQuery(JpaExtendQueryUtils.cleanOrderBy(query));
    }
}

