/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.data.jpa.extend.JpaExtendQueryLookupStrategy;
import com.taotao.boot.data.jpa.extend.RevisionRepositoryFactory;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.DefaultJpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.Nullable;

public class JpaExtendRepositoryFactory
extends RevisionRepositoryFactory {
    private final EntityManager entityManager;
    private final PersistenceProvider extractor;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private JpaQueryMethodFactory queryMethodFactory;
    private QueryRewriterProvider queryRewriterProvider;

    JpaExtendRepositoryFactory(EntityManager entityManager, Class<?> revisionEntityClass) {
        super(entityManager, revisionEntityClass);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager((EntityManager)entityManager);
        this.queryMethodFactory = new DefaultJpaQueryMethodFactory((QueryExtractor)this.extractor);
        this.queryRewriterProvider = QueryRewriterProvider.simple();
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(JpaExtendQueryLookupStrategy.create(this.entityManager, this.queryMethodFactory, key, evaluationContextProvider, this.queryRewriterProvider, this.escapeCharacter));
    }
}

