/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.common.utils.log.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyChainedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.transform.ResultTransformer;

public class JpaExtendResultTransformer
implements ResultTransformer {
    private final Class resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;
    private static Map<Class<?>, Function> typeConversionMap = new HashMap();

    private static Boolean parseBoolean(String arg) {
        if (StringUtils.isNumeric((CharSequence)arg)) {
            if ("0".equals(arg)) {
                return false;
            }
        } else {
            return Boolean.parseBoolean(arg);
        }
        return true;
    }

    public JpaExtendResultTransformer(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.isInitialized = false;
        this.resultClass = resultClass;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        try {
            if (this.resultClass.isAssignableFrom(Map.class)) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                for (int i = 0; i < tuple.length; ++i) {
                    String alias = aliases[i];
                    if (alias == null) continue;
                    result.put(alias, tuple[i]);
                }
                return result;
            }
            aliases = this.camelAliases(aliases);
            if (!this.isInitialized) {
                this.initialize(aliases);
            } else {
                this.check(aliases);
            }
            Object result = this.resultClass.newInstance();
            for (int i = 0; i < aliases.length; ++i) {
                if (this.setters[i] == null || this.setters[i].getMethod() == null) continue;
                Class<?> paramType = this.setters[i].getMethod().getParameterTypes()[0];
                Function convertType = typeConversionMap.get(paramType);
                Object convertedObject = convertType == null ? tuple[i] : (tuple[i] == null ? null : convertType.apply(tuple[i]));
                this.setters[i].set(result, convertedObject);
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new HibernateException("Could not instantiate result class: " + this.resultClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Could not instantiate result class: " + this.resultClass.getName());
        }
    }

    private String[] camelAliases(String[] aliases) {
        return aliases == null || aliases.length == 0 ? aliases : (String[])Arrays.stream(aliases).map(alias -> this.removeSeparatorsToCamelString((String)alias, '_')).toArray(String[]::new);
    }

    private void initialize(String[] aliases) {
        PropertyAccessStrategyChainedImpl propertyAccessStrategy = new PropertyAccessStrategyChainedImpl(new PropertyAccessStrategy[]{PropertyAccessStrategyBasicImpl.INSTANCE, PropertyAccessStrategyFieldImpl.INSTANCE, PropertyAccessStrategyMapImpl.INSTANCE});
        this.aliases = new String[aliases.length];
        this.setters = new Setter[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null || !this.checkPropertySetter(this.resultClass, alias)) continue;
            this.aliases[i] = alias;
            this.setters[i] = propertyAccessStrategy.buildPropertyAccess(this.resultClass, alias, true).getSetter();
        }
        this.isInitialized = true;
    }

    private boolean checkPropertySetter(Class containerJavaType, String propertyName) {
        Class<?> propertyType = null;
        try {
            Method getterMethod = ReflectHelper.findGetterMethod((Class)containerJavaType, (String)propertyName);
            propertyType = getterMethod.getReturnType();
        }
        catch (PropertyNotFoundException ex) {
            LogUtils.debug((String)"class :{} can not find propertyName:{} getterMethod", (Object[])new Object[]{containerJavaType, propertyName});
            try {
                Field field = ReflectHelper.findField((Class)containerJavaType, (String)propertyName);
                propertyType = field.getType();
            }
            catch (PropertyNotFoundException e) {
                LogUtils.debug((String)"class :{} can not find property:{}", (Object[])new Object[]{containerJavaType, propertyName});
            }
        }
        if (propertyType == null) {
            LogUtils.debug((String)"class :{} can not find propertyName:{} setterMethod", (Object[])new Object[]{containerJavaType, propertyName});
            return false;
        }
        Method setterMethod = ReflectHelper.setterMethodOrNull((Class)containerJavaType, (String)propertyName, propertyType);
        return setterMethod != null;
    }

    private void check(String[] aliases) {
        if (!Arrays.equals(aliases, this.aliases)) {
            LogUtils.debug((String)("aliases are different from what is cached; aliases=" + String.valueOf(Arrays.asList(aliases)) + " cached=" + String.valueOf(Arrays.asList(this.aliases))), (Object[])new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaExtendResultTransformer that = (JpaExtendResultTransformer)JpaExtendResultTransformer.class.cast(o);
        if (!this.resultClass.equals(that.resultClass)) {
            return false;
        }
        return Arrays.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int result = this.resultClass.hashCode();
        result = 31 * result + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
        return result;
    }

    private String removeSeparatorsToCamelString(String s, char separator) {
        StringBuilder result = new StringBuilder(s);
        for (int i = 1; i < result.length(); ++i) {
            if (result.charAt(i - 1) != separator) continue;
            result.deleteCharAt(i - 1);
            if (i - 1 >= result.length()) continue;
            result.setCharAt(i - 1, Character.toUpperCase(result.charAt(i - 1)));
        }
        return result.toString();
    }

    static {
        typeConversionMap.put(Long.class, v -> Long.valueOf(v.toString()));
        typeConversionMap.put(Long.TYPE, v -> Long.parseLong(v.toString()));
        typeConversionMap.put(Double.class, v -> Double.valueOf(v.toString()));
        typeConversionMap.put(Double.TYPE, v -> Double.parseDouble(v.toString()));
        typeConversionMap.put(Float.class, v -> Float.valueOf(v.toString()));
        typeConversionMap.put(Float.TYPE, v -> Float.valueOf(Float.parseFloat(v.toString())));
        typeConversionMap.put(Integer.class, v -> Integer.valueOf(v.toString()));
        typeConversionMap.put(Integer.TYPE, v -> Integer.parseInt(v.toString()));
        typeConversionMap.put(Boolean.class, v -> JpaExtendResultTransformer.parseBoolean(v.toString()) != false ? Boolean.TRUE : Boolean.FALSE);
        typeConversionMap.put(Boolean.TYPE, v -> JpaExtendResultTransformer.parseBoolean(v.toString()) != false);
        typeConversionMap.put(LocalDateTime.class, v -> {
            if (Timestamp.class.isInstance(v)) {
                return ((Timestamp)Timestamp.class.cast(v)).toLocalDateTime();
            }
            if (Date.class.isInstance(v)) {
                return ((Date)Date.class.cast(v)).toLocalDate();
            }
            return v;
        });
    }
}

