/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.extend;

import com.taotao.boot.data.jpa.extend.DefaultRevisionEntityInformation;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.hibernate.envers.DefaultRevisionEntity;
import org.springframework.data.envers.repository.support.EnversRevisionRepositoryImpl;
import org.springframework.data.envers.repository.support.ReflectionRevisionEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.history.support.RevisionEntityInformation;

public class RevisionRepositoryFactory<T, ID, N extends Number>
extends JpaRepositoryFactory {
    private final RevisionEntityInformation revisionEntityInformation;
    private final EntityManager entityManager;

    public RevisionRepositoryFactory(EntityManager entityManager, Class<?> revisionEntityClass) {
        super(entityManager);
        this.entityManager = entityManager;
        this.revisionEntityInformation = Optional.ofNullable(revisionEntityClass).filter(it -> !it.equals(DefaultRevisionEntity.class)).map(ReflectionRevisionEntityInformation::new).orElseGet(DefaultRevisionEntityInformation::new);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        Object fragmentImplementation = this.getTargetRepositoryViaReflection(EnversRevisionRepositoryImpl.class, new Object[]{this.getEntityInformation(metadata.getDomainType()), this.revisionEntityInformation, this.entityManager});
        return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{fragmentImplementation}).append(super.getRepositoryFragments(metadata));
    }
}

