/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.ar.repo;

import com.taotao.boot.data.jpa.fenix.ar.BaseModel;
import com.taotao.boot.data.jpa.fenix.exception.FenixException;
import com.taotao.boot.data.jpa.fenix.helper.StringHelper;
import java.util.Optional;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public interface CrudModel<T, ID, R extends CrudRepository<T, ID>>
extends BaseModel<R> {
    public ID getId();

    @Override
    default public void validRepository(Object repository) {
        this.assertNotNullRepository(repository);
        if (!(repository instanceof CrudRepository)) {
            throw new FenixException(StringHelper.format("\u3010Fenix \u5f02\u5e38\u3011\u83b7\u53d6\u5230\u7684 Spring Data JPA \u7684 Repository \u63a5\u53e3\u3010{}\u3011\u4e0d\u662f\u771f\u6b63\u7684 CrudRepository \u63a5\u53e3\u3002", repository.getClass().getName()));
        }
    }

    @Transactional
    default public T save() {
        return (T)((CrudRepository)this.getRepository()).save((Object)this);
    }

    default public Optional<T> findById() {
        return ((CrudRepository)this.getRepository()).findById(this.getId());
    }

    default public boolean existsById() {
        return ((CrudRepository)this.getRepository()).existsById(this.getId());
    }

    @Transactional
    default public void delete() {
        ((CrudRepository)this.getRepository()).delete((Object)this);
    }

    @Transactional
    default public void deleteById() {
        ((CrudRepository)this.getRepository()).deleteById(this.getId());
    }
}

