/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.config;

import com.taotao.boot.data.jpa.fenix.config.entity.TagHandler;
import com.taotao.boot.data.jpa.fenix.core.FenixHandler;
import com.taotao.boot.data.jpa.fenix.core.FenixHandlerFactory;
import com.taotao.boot.data.jpa.fenix.core.concrete.BetweenHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.ChooseHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.EndsWithHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.ImportHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.InHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.IsNullHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.LikeHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.NormalHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.SetHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.StartsWithHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.TextHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.TrimWhereHandler;
import com.taotao.boot.data.jpa.fenix.core.concrete.WhereHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.AbstractPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.BetweenPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.EndsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.EqualsPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.GreaterThanEqualPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.GreaterThanPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.InPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.IsNotNullPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.IsNullPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.JoinPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LessThanEqualPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LessThanPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LikeInPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LikeOrLikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LikePatternPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.LikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotBetweenPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotEndsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotEqualsPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotInPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotLikePatternPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotLikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.NotStartsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrBetweenPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrEndsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrEqualsPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrGreaterThanEqualPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrGreaterThanPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrInPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrIsNotNullPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrIsNullPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrLessThanEqualPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrLessThanPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrLikeOrLikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrLikePatternPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrLikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotBetweenPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotEndsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotEqualsPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotInPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotLikePatternPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotLikePredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrNotStartsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.OrStartsWithPredicateHandler;
import com.taotao.boot.data.jpa.fenix.specification.handler.impl.StartsWithPredicateHandler;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.dom4j.Node;

public class FenixConfig {
    private boolean debug;
    private boolean printBanner = true;
    private boolean printSqlInfo;
    protected String xmlLocations = "fenix";
    protected String handlerLocations;
    private String underscoreTransformerPrefix;
    private static final Map<String, Node> fenixs = new HashMap<String, Node>();
    private static final Map<String, Set<URL>> xmlUrlMap = new HashMap<String, Set<URL>>();
    private static final Map<String, TagHandler> tagHandlerMap = new HashMap<String, TagHandler>(128);
    private static final Map<Class<?>, AbstractPredicateHandler> specificationHandlerMap = new HashMap(64);

    public static Map<String, Node> getFenixs() {
        return fenixs;
    }

    public static Map<String, Set<URL>> getXmlUrlMap() {
        return xmlUrlMap;
    }

    public static Map<String, TagHandler> getTagHandlerMap() {
        return tagHandlerMap;
    }

    public static Map<Class<?>, AbstractPredicateHandler> getSpecificationHandlerMap() {
        return specificationHandlerMap;
    }

    private static void initDefaultTagHandler() {
        FenixConfig.add("equal", NormalHandler::new, " = ");
        FenixConfig.add("andEqual", " AND ", NormalHandler::new, " = ");
        FenixConfig.add("orEqual", " OR ", NormalHandler::new, " = ");
        FenixConfig.add("notEqual", NormalHandler::new, " <> ");
        FenixConfig.add("andNotEqual", " AND ", NormalHandler::new, " <> ");
        FenixConfig.add("orNotEqual", " OR ", NormalHandler::new, " <> ");
        FenixConfig.add("greaterThan", NormalHandler::new, " > ");
        FenixConfig.add("andGreaterThan", " AND ", NormalHandler::new, " > ");
        FenixConfig.add("orGreaterThan", " OR ", NormalHandler::new, " > ");
        FenixConfig.add("lessThan", NormalHandler::new, " < ");
        FenixConfig.add("andLessThan", " AND ", NormalHandler::new, " < ");
        FenixConfig.add("orLessThan", " OR ", NormalHandler::new, " < ");
        FenixConfig.add("greaterThanEqual", NormalHandler::new, " >= ");
        FenixConfig.add("andGreaterThanEqual", " AND ", NormalHandler::new, " >= ");
        FenixConfig.add("orGreaterThanEqual", " OR ", NormalHandler::new, " >= ");
        FenixConfig.add("lessThanEqual", NormalHandler::new, " <= ");
        FenixConfig.add("andLessThanEqual", " AND ", NormalHandler::new, " <= ");
        FenixConfig.add("orLessThanEqual", " OR ", NormalHandler::new, " <= ");
        FenixConfig.add("like", LikeHandler::new, " LIKE ");
        FenixConfig.add("andLike", " AND ", LikeHandler::new, " LIKE ");
        FenixConfig.add("orLike", " OR ", LikeHandler::new, " LIKE ");
        FenixConfig.add("notLike", LikeHandler::new, " NOT LIKE ");
        FenixConfig.add("andNotLike", " AND ", LikeHandler::new, " NOT LIKE ");
        FenixConfig.add("orNotLike", " OR ", LikeHandler::new, " NOT LIKE ");
        FenixConfig.add("startsWith", StartsWithHandler::new, " LIKE ");
        FenixConfig.add("andStartsWith", " AND ", StartsWithHandler::new, " LIKE ");
        FenixConfig.add("orStartsWith", " OR ", StartsWithHandler::new, " LIKE ");
        FenixConfig.add("notStartsWith", StartsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("andNotStartsWith", " AND ", StartsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("orNotStartsWith", " OR ", StartsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("endsWith", EndsWithHandler::new, " LIKE ");
        FenixConfig.add("andEndsWith", " AND ", EndsWithHandler::new, " LIKE ");
        FenixConfig.add("orEndsWith", " OR ", EndsWithHandler::new, " LIKE ");
        FenixConfig.add("notEndsWith", EndsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("andNotEndsWith", " AND ", EndsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("orNotEndsWith", " OR ", EndsWithHandler::new, " NOT LIKE ");
        FenixConfig.add("between", BetweenHandler::new);
        FenixConfig.add("andBetween", " AND ", BetweenHandler::new);
        FenixConfig.add("orBetween", " OR ", BetweenHandler::new);
        FenixConfig.add("in", InHandler::new, " IN ");
        FenixConfig.add("andIn", " AND ", InHandler::new, " IN ");
        FenixConfig.add("orIn", " OR ", InHandler::new, " IN ");
        FenixConfig.add("notIn", InHandler::new, " NOT IN ");
        FenixConfig.add("andNotIn", " AND ", InHandler::new, " NOT IN ");
        FenixConfig.add("orNotIn", " OR ", InHandler::new, " NOT IN ");
        FenixConfig.add("isNull", IsNullHandler::new, " IS NULL ");
        FenixConfig.add("andIsNull", " AND ", IsNullHandler::new, " IS NULL ");
        FenixConfig.add("orIsNull", " OR ", IsNullHandler::new, " IS NULL ");
        FenixConfig.add("isNotNull", IsNullHandler::new, " IS NOT NULL ");
        FenixConfig.add("andIsNotNull", " AND ", IsNullHandler::new, " IS NOT NULL ");
        FenixConfig.add("orIsNotNull", " OR ", IsNullHandler::new, " IS NOT NULL ");
        FenixConfig.add("text", TextHandler::new);
        FenixConfig.add("import", ImportHandler::new);
        FenixConfig.add("choose", ChooseHandler::new);
        FenixConfig.add("set", SetHandler::new);
        FenixConfig.add("where", WhereHandler::new);
        FenixConfig.add("trimWhere", TrimWhereHandler::new);
    }

    private static void initDefaultSpecificationHandlers() {
        FenixConfig.add(new EqualsPredicateHandler());
        FenixConfig.add(new GreaterThanEqualPredicateHandler());
        FenixConfig.add(new GreaterThanPredicateHandler());
        FenixConfig.add(new InPredicateHandler());
        FenixConfig.add(new IsNotNullPredicateHandler());
        FenixConfig.add(new IsNullPredicateHandler());
        FenixConfig.add(new JoinPredicateHandler());
        FenixConfig.add(new LessThanEqualPredicateHandler());
        FenixConfig.add(new LessThanPredicateHandler());
        FenixConfig.add(new BetweenPredicateHandler());
        FenixConfig.add(new NotBetweenPredicateHandler());
        FenixConfig.add(new LikeInPredicateHandler());
        FenixConfig.add(new LikeOrLikePredicateHandler());
        FenixConfig.add(new LikePredicateHandler());
        FenixConfig.add(new NotLikePredicateHandler());
        FenixConfig.add(new StartsWithPredicateHandler());
        FenixConfig.add(new NotStartsWithPredicateHandler());
        FenixConfig.add(new EndsWithPredicateHandler());
        FenixConfig.add(new NotEndsWithPredicateHandler());
        FenixConfig.add(new LikePatternPredicateHandler());
        FenixConfig.add(new NotLikePatternPredicateHandler());
        FenixConfig.add(new NotEqualsPredicateHandler());
        FenixConfig.add(new NotInPredicateHandler());
        FenixConfig.add(new OrEqualsPredicateHandler());
        FenixConfig.add(new OrGreaterThanEqualPredicateHandler());
        FenixConfig.add(new OrGreaterThanPredicateHandler());
        FenixConfig.add(new OrInPredicateHandler());
        FenixConfig.add(new OrIsNotNullPredicateHandler());
        FenixConfig.add(new OrIsNullPredicateHandler());
        FenixConfig.add(new OrLessThanEqualPredicateHandler());
        FenixConfig.add(new OrLessThanPredicateHandler());
        FenixConfig.add(new OrBetweenPredicateHandler());
        FenixConfig.add(new OrNotBetweenPredicateHandler());
        FenixConfig.add(new OrLikeOrLikePredicateHandler());
        FenixConfig.add(new OrLikePredicateHandler());
        FenixConfig.add(new OrNotLikePredicateHandler());
        FenixConfig.add(new OrNotEqualsPredicateHandler());
        FenixConfig.add(new OrNotInPredicateHandler());
        FenixConfig.add(new OrStartsWithPredicateHandler());
        FenixConfig.add(new OrNotStartsWithPredicateHandler());
        FenixConfig.add(new OrEndsWithPredicateHandler());
        FenixConfig.add(new OrNotEndsWithPredicateHandler());
        FenixConfig.add(new OrLikePatternPredicateHandler());
        FenixConfig.add(new OrNotLikePatternPredicateHandler());
    }

    public FenixConfig setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public FenixConfig setPrintBanner(boolean enabled) {
        this.printBanner = enabled;
        return this;
    }

    public FenixConfig setPrintSqlInfo(boolean enabled) {
        this.printSqlInfo = enabled;
        return this;
    }

    public FenixConfig setXmlLocations(String xmlLocations) {
        this.xmlLocations = xmlLocations;
        return this;
    }

    public FenixConfig setHandlerLocations(String handlerLocations) {
        this.handlerLocations = handlerLocations;
        return this;
    }

    public FenixConfig setUnderscoreTransformerPrefix(String underscoreTransformerPrefix) {
        this.underscoreTransformerPrefix = underscoreTransformerPrefix;
        return this;
    }

    public static void add(String tagName, Class<? extends FenixHandler> handlerCls) {
        tagHandlerMap.put(tagName, new TagHandler(handlerCls));
    }

    public static void add(String tagName, FenixHandlerFactory handlerFactory) {
        tagHandlerMap.put(tagName, new TagHandler(handlerFactory));
    }

    public static void add(String tagName, String prefix, Class<? extends FenixHandler> handlerCls) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerCls));
    }

    public static void add(String tagName, String prefix, FenixHandlerFactory handlerFactory) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerFactory));
    }

    public static void add(String tagName, Class<? extends FenixHandler> handlerCls, String symbol) {
        tagHandlerMap.put(tagName, new TagHandler(handlerCls, symbol));
    }

    public static void add(String tagName, FenixHandlerFactory handlerFactory, String symbol) {
        tagHandlerMap.put(tagName, new TagHandler(handlerFactory, symbol));
    }

    public static void add(String tagName, String prefix, Class<? extends FenixHandler> handlerCls, String symbol) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerCls, symbol));
    }

    public static void add(String tagName, String prefix, FenixHandlerFactory handlerFactory, String symbol) {
        tagHandlerMap.put(tagName, new TagHandler(prefix, handlerFactory, symbol));
    }

    public static void add(Supplier<AbstractPredicateHandler> handlerSupplier) {
        AbstractPredicateHandler handler = handlerSupplier.get();
        specificationHandlerMap.put(handler.getAnnotation(), handler);
    }

    public static void add(AbstractPredicateHandler handler) {
        specificationHandlerMap.put(handler.getAnnotation(), handler);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isPrintBanner() {
        return this.printBanner;
    }

    public boolean isPrintSqlInfo() {
        return this.printSqlInfo;
    }

    public String getXmlLocations() {
        return this.xmlLocations;
    }

    public String getHandlerLocations() {
        return this.handlerLocations;
    }

    public String getUnderscoreTransformerPrefix() {
        return this.underscoreTransformerPrefix;
    }

    static {
        FenixConfig.initDefaultTagHandler();
        FenixConfig.initDefaultSpecificationHandlers();
    }
}

