/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.helpers.MessageFormatter;

public final class StringHelper {
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\|\t|\r|\n");
    private static final String PATTERN_WHERE_AND_OR_BLANK = "(?i) WHERE AND | WHERE OR ";
    private static final String WHERE = " WHERE ";
    private static final String WHERE_PREV_SPACE = " WHERE";
    private static final String XML_EXT = ".xml";
    private static final String JAVA_EXT = ".java";
    private static final String CLASS_EXT = ".class";

    public static String replaceBlank(String str) {
        Matcher m = BLANK_PATTERN.matcher(str);
        return m.replaceAll("").replaceAll("\\s{2,}", " ").trim();
    }

    public static String replaceWhereAndOr(String s) {
        if ((s = s.replaceAll(PATTERN_WHERE_AND_OR_BLANK, WHERE).replaceAll("(?i) WHERE ORDER BY ", " ORDER BY ").replaceAll("(?i) WHERE GROUP BY ", " GROUP BY ")).endsWith(WHERE_PREV_SPACE)) {
            s = s.substring(0, s.lastIndexOf(WHERE_PREV_SPACE));
        }
        return s;
    }

    public static boolean isEmptyObject(Object o) {
        return o == null || o instanceof String && StringHelper.isBlank((String)o);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringHelper.isBlank(str);
    }

    public static String format(String pattern, Object ... args) {
        return pattern == null ? "" : MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
    }

    public static String concat(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        for (Object o : objs) {
            sb.append(o == null ? "" : o.toString());
        }
        return sb.toString();
    }

    public static String fixDot(String text) {
        return text.contains(".") ? text.replace(".", "_") : text;
    }

    private static boolean isExtFile(String filePath, String ext) {
        return filePath != null && filePath.endsWith(ext);
    }

    public static boolean isXmlFile(String filePath) {
        return StringHelper.isExtFile(filePath, XML_EXT);
    }

    public static boolean isJavaFile(String filePath) {
        return StringHelper.isExtFile(filePath, JAVA_EXT);
    }

    public static boolean isClassFile(String filePath) {
        return StringHelper.isExtFile(filePath, CLASS_EXT);
    }
}

