/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.id;

import java.util.HashMap;
import java.util.Map;

public final class Radix {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int RADIX_10 = 10;
    static final int RADIX_62 = DIGITS.length;
    private static final Map<Character, Integer> digitMap = new HashMap<Character, Integer>();

    public static String toString(long i, int radix) {
        boolean negative;
        if (radix < 2 || radix > RADIX_62) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        int size = 65;
        int charPos = 64;
        char[] buf = new char[65];
        while (i <= (long)(-radix)) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
            i /= (long)radix;
        }
        buf[charPos] = DIGITS[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private static NumberFormatException throwNumberFormatException(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    public static long toNumber(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX (2).");
        }
        if (radix > RADIX_62) {
            throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX (62).");
        }
        int len = s.length();
        if (len == 0) {
            throw Radix.throwNumberFormatException(s);
        }
        boolean negative = false;
        int i = 0;
        long limit = -9223372036854775807L;
        char firstChar = s.charAt(0);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                throw Radix.throwNumberFormatException(s);
            }
            if (len == 1) {
                throw Radix.throwNumberFormatException(s);
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        long result = 0L;
        while (i < len) {
            Integer digit;
            if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null || digit < 0 || result < multmin) {
                throw Radix.throwNumberFormatException(s);
            }
            if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                throw Radix.throwNumberFormatException(s);
            }
            result -= (long)digit.intValue();
        }
        return negative ? result : -result;
    }

    public static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Radix.toString(hi | val & hi - 1L, RADIX_62).substring(1);
    }

    static {
        int len = DIGITS.length;
        for (int i = 0; i < len; ++i) {
            digitMap.put(Character.valueOf(DIGITS[i]), i);
        }
    }
}

