/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.jpa;

import com.taotao.boot.data.jpa.fenix.bean.SqlInfo;
import com.taotao.boot.data.jpa.fenix.core.Fenix;
import com.taotao.boot.data.jpa.fenix.helper.ClassMethodInvoker;
import com.taotao.boot.data.jpa.fenix.helper.QueryHelper;
import com.taotao.boot.data.jpa.fenix.helper.StringHelper;
import com.taotao.boot.data.jpa.fenix.jpa.FenixQueryInfo;
import com.taotao.boot.data.jpa.fenix.jpa.QueryFenix;
import com.taotao.boot.data.jpa.fenix.jpa.QueryResultContext;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;

public class FenixJpaQuery
extends AbstractJpaQuery {
    private static final String REGX_SELECT_FROM = "((?i)select)([\\s\\S]*?)((?i)from)";
    private static final String SELECT_COUNT = "select count(*) as count from ";
    private static final String REGX_SELECT_FROM_DISTINCT = "((?i)select)([\\s\\S]*?)((?i)distinct)\\s+([\\s\\S]*?)((?i)from)";
    private static final String REGX_SQL_ALIAS = "\\s+((?i)as)\\s+[^,\\s]+";
    private static final Pattern SELECT_FROM_PATTERN = Pattern.compile("((?i)select)([\\s\\S]*?)((?i)from)");
    private static final Pattern SELECT_FROM_DISTINCT_PATTERN = Pattern.compile("((?i)select)([\\s\\S]*?)((?i)distinct)\\s+([\\s\\S]*?)((?i)from)");
    private JpaParameters jpaParams;
    private QueryFenix queryFenix;
    private Class<?> queryClass;

    public JpaParameters getJpaParams() {
        return this.jpaParams;
    }

    public QueryFenix getQueryFenix() {
        return this.queryFenix;
    }

    public Class<?> getQueryClass() {
        return this.queryClass;
    }

    public void setJpaParams(JpaParameters jpaParams) {
        this.jpaParams = jpaParams;
    }

    public void setQueryFenix(QueryFenix queryFenix) {
        this.queryFenix = queryFenix;
    }

    public void setQueryClass(Class<?> queryClass) {
        this.queryClass = queryClass;
    }

    FenixJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
    }

    protected Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        return this.doCreateQuery(accessor.getValues());
    }

    protected Query doCreateQuery(Object[] values) {
        String resultType;
        Class<?> type;
        JpaQueryMethod jpaMethod = super.getQueryMethod();
        this.jpaParams = jpaMethod.getParameters();
        FenixQueryInfo fenixQueryInfo = FenixQueryInfo.getInstance();
        fenixQueryInfo.setContextParams(this.buildContextParams(values));
        SqlInfo sqlInfo = this.getSqlInfoByFenix();
        fenixQueryInfo.setSqlInfo(sqlInfo);
        fenixQueryInfo.setQuerySql(sqlInfo.getSql());
        Pageable pageable = this.buildPagableAndSortSql(values, fenixQueryInfo.getQuerySql());
        EntityManager em = super.getEntityManager();
        String querySql = fenixQueryInfo.getQuerySql();
        Query query = this.queryFenix.nativeQuery() ? ((type = this.getTypeToQueryFor(jpaMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)jpaMethod.getParameters(), values)).getReturnedType(), querySql)) == null ? em.createNativeQuery(querySql) : em.createNativeQuery(querySql, type)) : em.createQuery(querySql);
        sqlInfo.getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        if (pageable != null && pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset());
            query.setMaxResults(pageable.getPageSize());
        }
        if (StringHelper.isNotBlank(resultType = sqlInfo.getResultType()) || this.queryFenix.resultType() != Void.class) {
            query = QueryResultContext.buildTransformer(query, resultType, this.queryFenix);
        }
        if (pageable == null || pageable.isUnpaged()) {
            fenixQueryInfo.remove();
        }
        return query;
    }

    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        return this.doCreateCountQuery(accessor.getValues());
    }

    protected Query doCreateCountQuery(Object[] values) {
        String countSql = this.getCountSql();
        EntityManager em = this.getEntityManager();
        Query query = this.queryFenix.nativeQuery() ? em.createNativeQuery(countSql) : em.createQuery(countSql, Long.class);
        FenixQueryInfo.getInstance().getSqlInfo().getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        FenixQueryInfo fenixQueryInfo = FenixQueryInfo.getLocalThreadInstance();
        if (fenixQueryInfo != null) {
            fenixQueryInfo.remove();
        }
        return query;
    }

    private Class<?> getTypeToQueryFor(ReturnedType returnedType, String querySql) {
        Class<Tuple> result;
        Class<Tuple> clazz = result = this.getQueryMethod().isQueryForEntity() ? returnedType.getDomainType() : null;
        if (QueryUtils.hasConstructorExpression((String)querySql) || QueryUtils.getProjection((String)querySql).equalsIgnoreCase(QueryHelper.detectAlias(querySql))) {
            return result;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : result;
    }

    private Map<String, Object> buildContextParams(Object[] values) {
        int len = this.jpaParams.getNumberOfParameters();
        HashMap<String, Object> context = new HashMap<String, Object>(len);
        for (int i = 0; i < len; ++i) {
            Optional nameOptional;
            Parameter parameter = this.jpaParams.getParameter(i);
            if (parameter.isSpecialParameter() || !(nameOptional = parameter.getName()).isPresent()) continue;
            context.put((String)nameOptional.get(), values[i]);
        }
        return context;
    }

    private SqlInfo getSqlInfoByFenix() {
        Class<?> provider = this.queryFenix.provider();
        String method = this.queryFenix.method();
        String fenixId = this.queryFenix.value();
        Map<String, Object> contextParams = FenixQueryInfo.getInstance().getContextParams();
        if (provider != Void.class) {
            if (StringHelper.isNotBlank(method)) {
                return ClassMethodInvoker.invoke(provider, method, contextParams);
            }
            if (StringHelper.isNotBlank(fenixId)) {
                return this.getXmlSqlInfo(fenixId, contextParams);
            }
            return ClassMethodInvoker.invoke(provider, this.getQueryMethod().getName(), contextParams);
        }
        return StringHelper.isNotBlank(fenixId) ? this.getXmlSqlInfo(fenixId, contextParams) : Fenix.getXmlSqlInfo(this.queryClass.getName(), this.getQueryMethod().getName(), contextParams);
    }

    private SqlInfo getXmlSqlInfo(String fenixId, Map<String, Object> contextParams) {
        if (fenixId.contains(".")) {
            int i = fenixId.lastIndexOf(".");
            return Fenix.getXmlSqlInfo(fenixId.substring(0, i), fenixId.substring(i + 1), contextParams);
        }
        return Fenix.getXmlSqlInfo(this.queryClass.getName(), fenixId, contextParams);
    }

    private Pageable buildPagableAndSortSql(Object[] values, String querySql) {
        Pageable pageable = null;
        FenixQueryInfo fenixQueryInfo = FenixQueryInfo.getInstance();
        if (this.jpaParams.hasPageableParameter() && (pageable = (Pageable)values[this.jpaParams.getPageableIndex()]) != null) {
            fenixQueryInfo.setQuerySql(QueryUtils.applySorting((String)querySql, (Sort)pageable.getSort(), (String)QueryHelper.detectAlias(querySql)));
        }
        if (this.jpaParams.hasSortParameter()) {
            fenixQueryInfo.setQuerySql(QueryUtils.applySorting((String)querySql, (Sort)new ParametersParameterAccessor((Parameters)this.jpaParams, values).getSort(), (String)QueryHelper.detectAlias(querySql)));
        }
        return pageable;
    }

    private String getCountSql() {
        Class<?> provider = this.queryFenix.provider();
        String xmlCountQuery = this.queryFenix.countQuery();
        String countMethod = this.queryFenix.countMethod();
        FenixQueryInfo fenixQueryInfo = FenixQueryInfo.getInstance();
        Map<String, Object> contextParams = fenixQueryInfo.getContextParams();
        if (provider != Void.class) {
            if (StringHelper.isNotBlank(countMethod)) {
                fenixQueryInfo.setSqlInfo(ClassMethodInvoker.invoke(provider, countMethod, contextParams));
                return fenixQueryInfo.getSqlInfo().getSql();
            }
            if (StringHelper.isNotBlank(xmlCountQuery)) {
                fenixQueryInfo.setSqlInfo(this.getXmlSqlInfo(xmlCountQuery, contextParams));
                return fenixQueryInfo.getSqlInfo().getSql();
            }
            return this.getCountSqlByQueryInfo(fenixQueryInfo);
        }
        if (StringHelper.isNotBlank(xmlCountQuery)) {
            fenixQueryInfo.setSqlInfo(this.getXmlSqlInfo(xmlCountQuery, contextParams));
            return fenixQueryInfo.getSqlInfo().getSql();
        }
        return this.getCountSqlByQueryInfo(fenixQueryInfo);
    }

    private String getCountSqlByQueryInfo(FenixQueryInfo fenixQueryInfo) {
        boolean enableDistinct = this.queryFenix.enableDistinct();
        String infoSql = fenixQueryInfo.getSqlInfo().getSql();
        Matcher matcher = SELECT_FROM_PATTERN.matcher(infoSql);
        String countSql = matcher.replaceFirst(SELECT_COUNT);
        if (!enableDistinct) {
            return countSql;
        }
        String selectPrefix = matcher.group();
        if (!(matcher = SELECT_FROM_DISTINCT_PATTERN.matcher(selectPrefix)).find()) {
            return countSql;
        }
        String distinctColumn = matcher.group(4).replaceAll(REGX_SQL_ALIAS, "");
        return countSql.replaceFirst("count\\(\\*\\)", String.format("count(distinct %s)", distinctColumn));
    }
}

