/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.jpa;

import com.taotao.boot.data.jpa.fenix.jpa.FenixJpaClassWriter;
import com.taotao.boot.data.jpa.fenix.jpa.FenixJpaQuery;
import com.taotao.boot.data.jpa.fenix.jpa.QueryFenix;
import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.DefaultJpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

public class FenixQueryLookupStrategy
implements QueryLookupStrategy {
    private final EntityManager entityManager;
    private final QueryExtractor extractor;
    private final QueryLookupStrategy jpaQueryLookupStrategy;
    private Object queryMethodFactory;

    private FenixQueryLookupStrategy(EntityManager entityManager, QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider provider) {
        this.entityManager = entityManager;
        this.extractor = extractor;
        if (FenixJpaClassWriter.hasDefaultJpaQueryMethodFactoryClass()) {
            this.queryMethodFactory = new DefaultJpaQueryMethodFactory(extractor);
            this.jpaQueryLookupStrategy = JpaQueryLookupStrategy.create((EntityManager)entityManager, (JpaQueryMethodFactory)((JpaQueryMethodFactory)this.queryMethodFactory), (QueryLookupStrategy.Key)key, (QueryMethodEvaluationContextProvider)provider, (QueryRewriterProvider)QueryRewriterProvider.simple(), (EscapeCharacter)EscapeCharacter.DEFAULT);
        } else {
            this.jpaQueryLookupStrategy = this.createOldJpaQueryLookupStrategy(entityManager, key, extractor, provider, EscapeCharacter.DEFAULT);
        }
    }

    public QueryLookupStrategy createOldJpaQueryLookupStrategy(EntityManager entityManager, QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider provider, EscapeCharacter character) {
        return null;
    }

    static QueryLookupStrategy create(EntityManager entityManager, QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider provider) {
        return new FenixQueryLookupStrategy(entityManager, key, extractor, provider);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        QueryFenix queryFenixAnnotation = method.getAnnotation(QueryFenix.class);
        if (queryFenixAnnotation == null) {
            return this.jpaQueryLookupStrategy.resolveQuery(method, metadata, factory, namedQueries);
        }
        FenixJpaQuery fenixJpaQuery = this.queryMethodFactory == null ? this.createOldFenixJpaQuery(method, metadata, factory, this.extractor, this.entityManager) : new FenixJpaQuery(((JpaQueryMethodFactory)this.queryMethodFactory).build(method, metadata, factory), this.entityManager);
        fenixJpaQuery.setQueryFenix(queryFenixAnnotation);
        fenixJpaQuery.setQueryClass(method.getDeclaringClass());
        return fenixJpaQuery;
    }

    public FenixJpaQuery createOldFenixJpaQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor, EntityManager entityManager) {
        return null;
    }
}

