/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.jpa;

import com.taotao.boot.data.jpa.fenix.helper.StringHelper;
import com.taotao.boot.data.jpa.fenix.jpa.FenixJpaRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.SingularAttribute;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class FenixSimpleJpaRepository<T, ID>
extends SimpleJpaRepository<T, ID>
implements FenixJpaRepository<T, ID> {
    private static final String ENTITIES_NULL_MSG = "Entities must not be null!";
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;

    public FenixSimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
    }

    public FenixSimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getEntityInformation(domainClass, (EntityManager)em), em);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> void saveBatch(Iterable<S> entities) {
        this.saveBatch(entities, 500);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> void saveBatch(Iterable<S> entities, int batchSize) {
        Assert.notNull(entities, (String)ENTITIES_NULL_MSG);
        int i = 0;
        for (S entity : entities) {
            this.em.persist(entity);
            if (++i % batchSize != 0) continue;
            this.em.flush();
            this.em.clear();
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> void updateBatch(Iterable<S> entities) {
        this.updateBatch(entities, 500);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> void updateBatch(Iterable<S> entities, int batchSize) {
        Assert.notNull(entities, (String)ENTITIES_NULL_MSG);
        int i = 0;
        Session session = (Session)this.em.unwrap(Session.class);
        for (S entity : entities) {
            session.update(entity);
            if (++i % batchSize != 0) continue;
            this.em.flush();
            this.em.clear();
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> S saveOrUpdateByNotNullProperties(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null.");
        Object id = this.entityInformation.getId(entity);
        if (StringHelper.isEmptyObject(id)) {
            this.em.persist(entity);
            return entity;
        }
        Optional entityOptional = super.findById(id);
        if (!entityOptional.isPresent()) {
            this.em.persist(entity);
            return entity;
        }
        Object oldEntity = entityOptional.get();
        BeanUtils.copyProperties(entity, oldEntity, (String[])this.getNullProperties(entity));
        this.em.merge(oldEntity);
        return entity;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public <S extends T> void saveOrUpdateAllByNotNullProperties(Iterable<S> entities) {
        Assert.notNull(entities, (String)ENTITIES_NULL_MSG);
        for (S entity : entities) {
            this.saveOrUpdateByNotNullProperties(entity);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteByIds(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given ids must not be null!");
        for (ID id : ids) {
            super.deleteById(id);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchByIds(Iterable<ID> ids) {
        this.deleteBatchByIds(ids, 500);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchByIds(Iterable<ID> ids, int batchSize) {
        Assert.notNull(ids, (String)"The given ids must not be null!");
        Assert.isTrue((batchSize > 0 ? 1 : 0) != 0, (String)"The given batchSize must not be <= 0.");
        String entityName = this.entityInformation.getEntityName();
        SingularAttribute idAttribute = this.entityInformation.getIdAttribute();
        String idName = idAttribute == null ? "id" : idAttribute.getName();
        String sql = StringHelper.format("delete from {} where {} in :batch_ids", entityName, idName);
        int i = 0;
        ArrayList<ID> batchIds = new ArrayList<ID>();
        for (ID id : ids) {
            if (id == null) continue;
            batchIds.add(id);
            if (++i % batchSize != 0 || batchIds.isEmpty()) continue;
            this.doBatchDelete(sql, batchIds);
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.doBatchDelete(sql, batchIds);
        }
    }

    private void doBatchDelete(String sql, List<ID> batchIds) {
        this.em.createQuery(sql).setParameter("batch_ids", batchIds).executeUpdate();
    }

    private String[] getNullProperties(Object entity) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
        PropertyDescriptor[] propertyDescriptors = beanWrapper.getPropertyDescriptors();
        ArrayList<String> nullProperties = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            if (beanWrapper.getPropertyValue(propertyName) != null) continue;
            nullProperties.add(propertyName);
        }
        return nullProperties.toArray(new String[0]);
    }
}

