/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.fenix.starter;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.jpa.fenix.ar.RepositoryModelContext;
import com.taotao.boot.data.jpa.fenix.config.FenixConfig;
import com.taotao.boot.data.jpa.fenix.config.FenixConfigManager;
import com.taotao.boot.data.jpa.fenix.specification.handler.AbstractPredicateHandler;
import com.taotao.boot.data.jpa.fenix.starter.FenixProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={FenixProperties.class})
public class FenixAutoConfiguration {
    private final FenixProperties properties;

    @Autowired
    public FenixAutoConfiguration(ApplicationContext applicationContext, FenixProperties properties) {
        if (applicationContext == null) {
            throw new ApplicationContextException("\u3010Fenix \u5f02\u5e38\u3011\u672a\u83b7\u53d6\u5230 Spring \u4e2d\u7684 applicationContext \u5bf9\u8c61!");
        }
        RepositoryModelContext.setApplicationContext(applicationContext);
        this.properties = properties;
        this.doConfig();
    }

    private void doConfig() {
        Boolean debug = this.properties.getDebug();
        Boolean printBanner = this.properties.getPrintBanner();
        Boolean printSql = this.properties.getPrintSql();
        Boolean showJpaSql = this.properties.getShowJpaSql();
        List<String> xmlLocations = this.properties.getXmlLocations();
        List<String> handlerLocations = this.properties.getHandlerLocations();
        FenixConfigManager.getInstance().initLoad(new FenixConfig().setDebug(Boolean.TRUE.equals(debug)).setPrintBanner(printBanner == null || Boolean.TRUE.equals(printBanner)).setPrintSqlInfo(printSql == null ? Boolean.TRUE.equals(showJpaSql) : Boolean.TRUE.equals(printSql)).setUnderscoreTransformerPrefix(this.properties.getUnderscoreTransformerPrefix()).setXmlLocations(CollectionUtils.isEmpty(xmlLocations) ? null : String.join((CharSequence)",", xmlLocations)).setHandlerLocations(CollectionUtils.isEmpty(handlerLocations) ? null : String.join((CharSequence)",", handlerLocations)));
        List<String> predicateHandlers = this.properties.getPredicateHandlers();
        if (!CollectionUtils.isEmpty(predicateHandlers)) {
            for (String handlerName : predicateHandlers) {
                AbstractPredicateHandler handler = this.newHandlerInstance(handlerName.trim());
                if (handler == null) continue;
                FenixConfig.add(handler);
            }
        }
    }

    private AbstractPredicateHandler newHandlerInstance(String handlerName) {
        try {
            Object instance = Class.forName(handlerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return instance instanceof AbstractPredicateHandler ? (AbstractPredicateHandler)instance : null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LogUtils.error((String)"\u3010Fenix \u5f02\u5e38\u3011\u5b9e\u4f8b\u5316\u3010{}\u3011\u7c7b\u7684\u5bf9\u8c61\u5931\u8d25\uff0c\u5c06\u5ffd\u7565\u6b64\u7c7b\u7684\u5b9e\u4f8b\u5316\u3002", (Object[])new Object[]{handlerName, e});
            return null;
        }
    }
}

