/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.hibernate.identifier;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.type.descriptor.java.UUIDJavaType;

public abstract class AbstractUuidGenerator
implements IdentifierGenerator,
StandardGenerator {
    private final StandardRandomStrategy generator = StandardRandomStrategy.INSTANCE;
    private final UUIDJavaType.ValueTransformer valueTransformer;

    public AbstractUuidGenerator(Member idMember) {
        Class<?> propertyType = idMember instanceof Method ? ((Method)idMember).getReturnType() : ((Field)idMember).getType();
        if (UUID.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.PassThroughTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(propertyType)) {
            this.valueTransformer = UUIDJavaType.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + propertyType.getName() + "] for UUID conversion");
        }
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.valueTransformer.transform(this.generator.generateUuid(session));
    }
}

