/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.hibernate.spi.cache;

import com.taotao.boot.common.holder.TenantContextHolder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.crypto.SecureUtil;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class HerodotusDomainDataStorageAccess
implements DomainDataStorageAccess {
    private static final Logger log = LoggerFactory.getLogger(HerodotusDomainDataStorageAccess.class);
    private Cache cache;

    public HerodotusDomainDataStorageAccess() {
    }

    public HerodotusDomainDataStorageAccess(Cache cache) {
        this.cache = cache;
    }

    private String secure(Object key) {
        String original = String.valueOf(key);
        if (StringUtils.isNotBlank((CharSequence)original) && StringUtils.startsWith((CharSequence)original, (CharSequence)"sql:")) {
            String recent = SecureUtil.md5((String)original);
            log.trace("[ttc] |- SPI - Secure the sql type key [{}] to [{}]", (Object)original, (Object)recent);
            return recent;
        }
        return original;
    }

    private String getTenantId() {
        String tenantId = TenantContextHolder.getTenant();
        String result = StringUtils.isNotBlank((CharSequence)tenantId) ? tenantId : "tenant_id";
        log.trace("[ttc] |- SPI - Tenant identifier for jpa second level cache is : [{}]", (Object)result);
        return StringUtils.toRootLowerCase((String)result);
    }

    private String wrapper(Object key) {
        String original = this.secure(key);
        String tenantId = this.getTenantId();
        String result = tenantId + "_" + original;
        log.trace("[ttc] |- SPI - Current cache key is : [{}]", (Object)result);
        return result;
    }

    private Object get(Object key) {
        Cache.ValueWrapper value = this.cache.get(key);
        if (ObjectUtils.isNotEmpty((Object)value)) {
            return value.get();
        }
        return null;
    }

    public boolean contains(Object key) {
        String wrapperKey = this.wrapper(key);
        Object value = this.get(wrapperKey);
        log.trace("[ttc] |- SPI - check is key : [{}] exist.", (Object)wrapperKey);
        return ObjectUtils.isNotEmpty((Object)value);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        Object value = this.get(wrapperKey);
        log.trace("[ttc] |- SPI - get from cache key is : [{}], value is : [{}]", (Object)wrapperKey, value);
        return value;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        log.trace("[ttc] |- SPI - put into cache key is : [{}], value is : [{}]", (Object)wrapperKey, value);
        this.cache.put((Object)wrapperKey, value);
    }

    public void removeFromCache(Object key, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        log.trace("[ttc] |- SPI - remove from cache key is : [{}]", (Object)wrapperKey);
        this.cache.evict((Object)wrapperKey);
    }

    public void evictData(Object key) {
        String wrapperKey = this.wrapper(key);
        log.trace("[ttc] |- SPI - evict key : [{}] from cache.", (Object)wrapperKey);
        this.cache.evict((Object)wrapperKey);
    }

    public void clearCache(SharedSessionContractImplementor session) {
        this.evictData();
    }

    public void evictData() {
        log.trace("[ttc] |- SPI - clear all cache data.");
        this.cache.clear();
    }

    public void release() {
        log.trace("[ttc] |- SPI - cache release.");
        this.cache.invalidate();
    }
}

