/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.model;

import com.taotao.boot.data.jpa.model.SFunction;
import com.taotao.boot.data.jpa.model.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class FieldUtils {
    private static final Map<Class, WeakReference<SerializedLambda>> FUNC_CACHE = new ConcurrentHashMap<Class, WeakReference<SerializedLambda>>();

    public static <T> SerializedLambda resolve(SFunction<T, ?> func) {
        Class<?> clazz = func.getClass();
        return Optional.ofNullable(FUNC_CACHE.get(clazz)).map(Reference::get).orElseGet(() -> {
            SerializedLambda lambda = SerializedLambda.resolve(func);
            FUNC_CACHE.put(clazz, new WeakReference<SerializedLambda>(lambda));
            return lambda;
        });
    }

    public static <T> String propertyName(SFunction<T, ?> func) {
        SerializedLambda resolve = FieldUtils.resolve(func);
        String implMethodName = resolve.getImplMethodName();
        return implMethodName.substring(3).substring(0, 1).toLowerCase() + implMethodName.substring(4);
    }
}

