/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.tenant.datasource;

import com.taotao.boot.data.jpa.tenant.entity.SysTenantDataSource;
import com.taotao.boot.data.jpa.tenant.repository.SysTenantDataSourceRepository;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.stereotype.Component;

@Component
public class MultiTenantDataSourceFactory {
    @Autowired
    private SysTenantDataSourceRepository sysTenantDataSourceRepository;

    private DataSource createDataSource(DataSource defaultDataSource, SysTenantDataSource sysTenantDataSource) {
        if (defaultDataSource instanceof HikariDataSource) {
            HikariDataSource defaultHikariDataSource = (HikariDataSource)defaultDataSource;
            Properties defaultDataSourceProperties = defaultHikariDataSource.getDataSourceProperties();
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setDriverClassName(sysTenantDataSource.getDriverClassName());
            hikariConfig.setJdbcUrl(sysTenantDataSource.getUrl());
            hikariConfig.setUsername(sysTenantDataSource.getUsername());
            hikariConfig.setPassword(sysTenantDataSource.getPassword());
            if (ObjectUtils.isNotEmpty((Object)defaultDataSource)) {
                defaultDataSourceProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> hikariConfig.addDataSourceProperty(String.valueOf(key), value)));
            }
            return new HikariDataSource(hikariConfig);
        }
        return DataSourceBuilder.create().type(HikariDataSource.class).url(sysTenantDataSource.getUrl()).driverClassName(sysTenantDataSource.getDriverClassName()).username(sysTenantDataSource.getUsername()).password(sysTenantDataSource.getPassword()).build();
    }

    public Map<String, DataSource> getAll(DataSource defaultDataSource) {
        Iterable sysTenantDataSources = this.sysTenantDataSourceRepository.findAll();
        if (CollectionUtils.isNotEmpty((Collection)sysTenantDataSources)) {
            return sysTenantDataSources.stream().collect(Collectors.toMap(SysTenantDataSource::getTenantId, value -> this.createDataSource(defaultDataSource, (SysTenantDataSource)value)));
        }
        return new HashMap<String, DataSource>();
    }
}

