/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.tenant.hibernate;

import com.taotao.boot.data.jpa.tenant.datasource.MultiTenantDataSourceFactory;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;

public class DatabaseMultiTenantConnectionProvider
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl
implements HibernatePropertiesCustomizer {
    private static final Logger log = LoggerFactory.getLogger(DatabaseMultiTenantConnectionProvider.class);
    private boolean isDataSourceInit = false;
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private final DataSource defaultDataSource;

    public DatabaseMultiTenantConnectionProvider(DataSource dataSource) {
        this.defaultDataSource = dataSource;
        this.dataSources.put("public", dataSource);
    }

    private void initialize() {
        this.isDataSourceInit = true;
        MultiTenantDataSourceFactory factory = (MultiTenantDataSourceFactory)SpringUtil.getBean(MultiTenantDataSourceFactory.class, (Object[])new Object[0]);
        this.dataSources.putAll(factory.getAll(this.defaultDataSource));
    }

    protected DataSource selectAnyDataSource() {
        log.debug("[ttc] |- Select any dataSource: " + String.valueOf(this.defaultDataSource));
        return this.defaultDataSource;
    }

    protected DataSource selectDataSource(Object tenantIdentifier) {
        DataSource currentDataSource;
        if (!this.isDataSourceInit) {
            this.initialize();
        }
        if (ObjectUtils.isNotEmpty((Object)(currentDataSource = this.dataSources.get(tenantIdentifier)))) {
            log.debug("[ttc] |- Found the dataSource of [{}]", tenantIdentifier);
            return currentDataSource;
        }
        log.warn("[ttc] |- Cannot found the dataSource for [{}], change to use default.", tenantIdentifier);
        return this.defaultDataSource;
    }

    public void customize(Map<String, Object> hibernateProperties) {
        hibernateProperties.put("hibernate.multi_tenant_connection_provider", (Object)this);
    }
}

