/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.jpa.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.taotao.boot.common.model.BasePageQuery;
import com.taotao.boot.common.model.PageQuery;
import com.taotao.boot.common.model.PageResult;
import com.taotao.boot.common.utils.common.AntiSqlFilterUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class JpaUtils {
    @JsonIgnore
    public static <QueryDTO> Pageable buildJpaPage(BasePageQuery<QueryDTO> params) {
        if (CollUtil.isEmpty((Collection)params.getSortQuery())) {
            return PageRequest.of((int)params.getCurrentPage(), (int)params.getPageSize());
        }
        ArrayList orders = new ArrayList();
        params.getSortQuery().forEach(sortDTO -> {
            String filed = sortDTO.getFiled();
            String order = sortDTO.getOrder();
            String underlineSort = StrUtil.toUnderlineCase((CharSequence)filed);
            if (!StrUtil.equalsAny((CharSequence)filed, (CharSequence[])new CharSequence[]{"createTime", "updateTime"})) {
                underlineSort = AntiSqlFilterUtils.getSafeValue((String)underlineSort);
            }
            if (StrUtil.equalsAny((CharSequence)order, (CharSequence[])new CharSequence[]{"asc"})) {
                orders.add(Sort.Order.asc((String)underlineSort));
            } else {
                orders.add(Sort.Order.desc((String)underlineSort));
            }
        });
        return PageRequest.of((int)params.getCurrentPage(), (int)params.getPageSize(), (Sort)Sort.by(orders));
    }

    public static <T extends PageQuery> Pageable buildJpaPage(T pageParam) {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(Sort.Order.desc((String)"create_time"));
        if (StringUtils.isNotBlank((String)pageParam.getSort()) && StringUtils.isNotBlank((String)pageParam.getOrder())) {
            Sort.Order orderItem = "asc".equals(pageParam.getOrder()) ? Sort.Order.asc((String)pageParam.getSort()) : Sort.Order.desc((String)pageParam.getSort());
            orders.add(orderItem);
        }
        return PageRequest.of((int)pageParam.getCurrentPage(), (int)pageParam.getPageSize(), (Sort)Sort.by(orders));
    }

    public static <R, T> PageResult<R> convertJpaPage(Page<T> page, Class<R> r) {
        return JpaUtils.convertJpaPage(page, (T t) -> BeanUtil.toBean((Object)t, (Class)r));
    }

    public static <R, T> PageResult<R> convertJpaPage(Page<T> page, Function<T, R> function) {
        List records = page.getContent();
        List<R> collect = ((List)Optional.of(records).orElse(new ArrayList())).stream().filter(Objects::nonNull).map(function).toList();
        return PageResult.of((long)page.getTotalElements(), (int)page.getTotalPages(), (int)page.getNumber(), (int)page.getSize(), collect);
    }
}

