/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.jboss.logging.Logger;

public class PropertyContainer {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PropertyContainer.class.getName());
    private final XClass xClass;
    private final XClass entityAtStake;
    private final org.hibernate.boot.spi.AccessType classLevelAccessType;
    private final List<XProperty> persistentAttributes;

    public PropertyContainer(XClass clazz, XClass entityAtStake, org.hibernate.boot.spi.AccessType defaultClassLevelAccessType) {
        this.xClass = clazz;
        this.entityAtStake = entityAtStake;
        if (defaultClassLevelAccessType == org.hibernate.boot.spi.AccessType.DEFAULT) {
            defaultClassLevelAccessType = org.hibernate.boot.spi.AccessType.PROPERTY;
        }
        org.hibernate.boot.spi.AccessType localClassLevelAccessType = this.determineLocalClassDefinedAccessStrategy();
        assert (localClassLevelAccessType != null);
        org.hibernate.boot.spi.AccessType accessType = this.classLevelAccessType = localClassLevelAccessType != org.hibernate.boot.spi.AccessType.DEFAULT ? localClassLevelAccessType : defaultClassLevelAccessType;
        assert (this.classLevelAccessType == org.hibernate.boot.spi.AccessType.FIELD || this.classLevelAccessType == org.hibernate.boot.spi.AccessType.PROPERTY || this.classLevelAccessType == org.hibernate.boot.spi.AccessType.RECORD);
        List fields = this.xClass.getDeclaredProperties(org.hibernate.boot.spi.AccessType.FIELD.getType());
        List getters = this.xClass.getDeclaredProperties(org.hibernate.boot.spi.AccessType.PROPERTY.getType());
        List recordComponents = this.xClass.getDeclaredProperties(org.hibernate.boot.spi.AccessType.RECORD.getType());
        this.preFilter(fields, getters, recordComponents);
        HashMap<String, XProperty> persistentAttributesFromGetters = new HashMap<String, XProperty>();
        HashMap<String, XProperty> persistentAttributesFromComponents = new HashMap<String, XProperty>();
        LinkedHashMap<String, Object> localAttributeMap = !recordComponents.isEmpty() && recordComponents.size() == fields.size() ? new LinkedHashMap() : new LinkedHashMap<String, XProperty>();
        PropertyContainer.collectPersistentAttributesUsingLocalAccessType(this.xClass, localAttributeMap, persistentAttributesFromGetters, persistentAttributesFromComponents, fields, getters, recordComponents);
        PropertyContainer.collectPersistentAttributesUsingClassLevelAccessType(this.xClass, this.classLevelAccessType, localAttributeMap, persistentAttributesFromGetters, persistentAttributesFromComponents, fields, getters, recordComponents);
        this.persistentAttributes = PropertyContainer.verifyAndInitializePersistentAttributes(this.xClass, localAttributeMap);
    }

    private void preFilter(List<XProperty> fields, List<XProperty> getters, List<XProperty> recordComponents) {
        XProperty property;
        Iterator<XProperty> propertyIterator = fields.iterator();
        while (propertyIterator.hasNext()) {
            property = propertyIterator.next();
            if (!PropertyContainer.mustBeSkipped(property)) continue;
            propertyIterator.remove();
        }
        propertyIterator = getters.iterator();
        while (propertyIterator.hasNext()) {
            property = propertyIterator.next();
            if (!PropertyContainer.mustBeSkipped(property)) continue;
            propertyIterator.remove();
        }
        propertyIterator = recordComponents.iterator();
        while (propertyIterator.hasNext()) {
            property = propertyIterator.next();
            if (!PropertyContainer.mustBeSkipped(property)) continue;
            propertyIterator.remove();
        }
    }

    private static void collectPersistentAttributesUsingLocalAccessType(XClass xClass, Map<String, XProperty> persistentAttributeMap, Map<String, XProperty> persistentAttributesFromGetters, Map<String, XProperty> persistentAttributesFromComponents, List<XProperty> fields, List<XProperty> getters, List<XProperty> recordComponents) {
        String name;
        Access localAccessAnnotation;
        XProperty xProperty;
        Iterator<XProperty> propertyIterator = fields.iterator();
        while (propertyIterator.hasNext()) {
            xProperty = propertyIterator.next();
            localAccessAnnotation = (Access)xProperty.getAnnotation(Access.class);
            if (localAccessAnnotation == null || localAccessAnnotation.value() != AccessType.FIELD) continue;
            propertyIterator.remove();
            persistentAttributeMap.put(xProperty.getName(), xProperty);
        }
        propertyIterator = getters.iterator();
        while (propertyIterator.hasNext()) {
            xProperty = propertyIterator.next();
            localAccessAnnotation = (Access)xProperty.getAnnotation(Access.class);
            if (localAccessAnnotation == null || localAccessAnnotation.value() != AccessType.PROPERTY) continue;
            propertyIterator.remove();
            name = xProperty.getName();
            XProperty previous = persistentAttributesFromGetters.get(name);
            if (previous != null) {
                throw new MappingException(LOG.ambiguousPropertyMethods(xClass.getName(), HCANNHelper.annotatedElementSignature((XProperty)previous), HCANNHelper.annotatedElementSignature((XProperty)xProperty)), new Origin(SourceType.ANNOTATION, xClass.getName()));
            }
            persistentAttributeMap.put(name, xProperty);
            persistentAttributesFromGetters.put(name, xProperty);
        }
        propertyIterator = recordComponents.iterator();
        while (propertyIterator.hasNext()) {
            xProperty = propertyIterator.next();
            localAccessAnnotation = (Access)xProperty.getAnnotation(Access.class);
            if (localAccessAnnotation == null) continue;
            propertyIterator.remove();
            name = xProperty.getName();
            persistentAttributeMap.put(name, xProperty);
            persistentAttributesFromComponents.put(name, xProperty);
        }
    }

    private static void collectPersistentAttributesUsingClassLevelAccessType(XClass xClass, org.hibernate.boot.spi.AccessType classLevelAccessType, Map<String, XProperty> persistentAttributeMap, Map<String, XProperty> persistentAttributesFromGetters, Map<String, XProperty> persistentAttributesFromComponents, List<XProperty> fields, List<XProperty> getters, List<XProperty> recordComponents) {
        if (classLevelAccessType == org.hibernate.boot.spi.AccessType.FIELD) {
            for (XProperty field : fields) {
                String name = field.getName();
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(name, field);
            }
        } else {
            String name;
            for (XProperty getter : getters) {
                name = getter.getName();
                XProperty previous = persistentAttributesFromGetters.get(name);
                if (previous != null) {
                    throw new MappingException(LOG.ambiguousPropertyMethods(xClass.getName(), HCANNHelper.annotatedElementSignature((XProperty)previous), HCANNHelper.annotatedElementSignature((XProperty)getter)), new Origin(SourceType.ANNOTATION, xClass.getName()));
                }
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(getter.getName(), getter);
                persistentAttributesFromGetters.put(name, getter);
            }
            for (XProperty recordComponent : recordComponents) {
                name = recordComponent.getName();
                if (persistentAttributeMap.containsKey(name)) continue;
                persistentAttributeMap.put(name, recordComponent);
                persistentAttributesFromComponents.put(name, recordComponent);
            }
        }
    }

    public XClass getEntityAtStake() {
        return this.entityAtStake;
    }

    public XClass getDeclaringClass() {
        return this.xClass;
    }

    public org.hibernate.boot.spi.AccessType getClassLevelAccessType() {
        return this.classLevelAccessType;
    }

    public Iterable<XProperty> propertyIterator() {
        return this.persistentAttributes;
    }

    private static List<XProperty> verifyAndInitializePersistentAttributes(XClass xClass, Map<String, XProperty> localAttributeMap) {
        ArrayList<XProperty> output = new ArrayList<XProperty>(localAttributeMap.size());
        for (XProperty xProperty : localAttributeMap.values()) {
            if (!xProperty.isTypeResolved() && !PropertyContainer.discoverTypeWithoutReflection(xClass, xProperty)) {
                String msg = "Property '" + StringHelper.qualify((String)xClass.getName(), (String)xProperty.getName()) + "' has an unbound type and no explicit target entity (resolve this generics usage issue or set an explicit target attribute with '@OneToMany(target=)' or use an explicit '@Type')";
                throw new AnnotationException(msg);
            }
            output.add(xProperty);
        }
        return CollectionHelper.toSmallList(output);
    }

    private org.hibernate.boot.spi.AccessType determineLocalClassDefinedAccessStrategy() {
        org.hibernate.boot.spi.AccessType classDefinedAccessType = org.hibernate.boot.spi.AccessType.DEFAULT;
        Access access = (Access)this.xClass.getAnnotation(Access.class);
        if (access != null) {
            classDefinedAccessType = org.hibernate.boot.spi.AccessType.getAccessStrategy((AccessType)access.value());
        }
        return classDefinedAccessType;
    }

    private static boolean discoverTypeWithoutReflection(XClass clazz, XProperty property) {
        if (property.isAnnotationPresent(OneToOne.class) && !((OneToOne)property.getAnnotation(OneToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (property.isAnnotationPresent(OneToMany.class) && !((OneToMany)property.getAnnotation(OneToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (property.isAnnotationPresent(ManyToOne.class) && !((ManyToOne)property.getAnnotation(ManyToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (property.isAnnotationPresent(ManyToMany.class) && !((ManyToMany)property.getAnnotation(ManyToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (property.isAnnotationPresent(Any.class)) {
            return true;
        }
        if (property.isAnnotationPresent(ManyToAny.class)) {
            if (!property.isCollection() && !property.isArray()) {
                throw new AnnotationException("Property '" + StringHelper.qualify((String)clazz.getName(), (String)property.getName()) + "' annotated '@ManyToAny' is neither a collection nor an array");
            }
            return true;
        }
        if (property.isAnnotationPresent(Basic.class)) {
            return true;
        }
        if (property.isAnnotationPresent(Type.class)) {
            return true;
        }
        if (property.isAnnotationPresent(JavaType.class)) {
            return true;
        }
        if (property.isAnnotationPresent(JdbcTypeCode.class)) {
            return true;
        }
        return property.isAnnotationPresent(Target.class);
    }

    private static boolean mustBeSkipped(XProperty property) {
        return property.isAnnotationPresent(Transient.class) || "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(property.getType().getName());
    }
}

