/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.data.mybatis.interceptor.cipher.interceptor.FieldEncryptInterceptor;
import com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.interceptor.DataOperateInterceptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.config.EncryptorAutoConfiguration;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptorManager;
import com.taotao.boot.data.mybatis.interceptor.encrypt.interceptor.MybatisDecryptInterceptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.interceptor.MybatisEncryptInterceptor;
import com.taotao.boot.data.mybatis.interceptor.sql.BigResultQueryInterceptor;
import com.taotao.boot.data.mybatis.interceptor.sql.SlowSqlInterceptor;
import com.taotao.boot.data.mybatis.interceptor.sql.SqlCollectorInterceptor;
import com.taotao.boot.data.mybatis.interceptor.sql.SqlValidateInterceptor;
import com.taotao.boot.data.mybatis.interceptor.sqlanalysis.core.SqlAnalysisAspect;
import com.taotao.boot.data.mybatis.properties.MybatisInterceptorProperties;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration(after={EncryptorAutoConfiguration.class})
@ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor", name={"enabled"}, havingValue="true")
public class MybatisInterceptorAutoConfiguration
implements InitializingBean {
    private final MybatisInterceptorProperties interceptorProperties;

    public MybatisInterceptorAutoConfiguration(MybatisInterceptorProperties interceptorProperties) {
        this.interceptorProperties = interceptorProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MybatisInterceptorAutoConfiguration.class, (String)"taotao-boot-starter-data-mybatis", (String[])new String[0]);
    }

    @Bean
    @Order(value=1)
    public SqlAnalysisAspect getSqlAnalysisAspect() {
        SqlAnalysisAspect plugin = new SqlAnalysisAspect();
        Properties properties = new Properties();
        properties.setProperty("analysisSwitch", "true");
        properties.setProperty("onlyCheckOnce", "true");
        plugin.setProperties(properties);
        return plugin;
    }

    @Bean
    @Order(value=2)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.sql-log", name={"enabled"}, havingValue="true")
    public SlowSqlInterceptor sqlLogInterceptor() {
        return new SlowSqlInterceptor();
    }

    @Bean
    @Order(value=3)
    public SqlValidateInterceptor sqlValidateInterceptor() {
        return new SqlValidateInterceptor();
    }

    @Bean
    @Order(value=4)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.sql-collector", name={"enabled"}, havingValue="true")
    public SqlCollectorInterceptor sqlCollectorInterceptor(Collector collector) {
        return new SqlCollectorInterceptor(collector);
    }

    @Bean
    @Order(value=5)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.cipher-encrypt", name={"enabled"}, havingValue="true")
    public FieldEncryptInterceptor fieldEncryptInterceptor() {
        return new FieldEncryptInterceptor();
    }

    @Bean
    @Order(value=6)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.field-encrypt", name={"enabled"}, havingValue="true")
    public MybatisEncryptInterceptor mybatisEncryptInterceptor(EncryptorManager encryptorManager) {
        MybatisInterceptorProperties.FieldEncrypt fieldEncrypt = this.interceptorProperties.getFieldEncrypt();
        return new MybatisEncryptInterceptor(encryptorManager, fieldEncrypt);
    }

    @Bean
    @Order(value=7)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.field-encrypt", name={"enabled"}, havingValue="true")
    public MybatisDecryptInterceptor mybatisDecryptInterceptor(EncryptorManager encryptorManager) {
        MybatisInterceptorProperties.FieldEncrypt fieldEncrypt = this.interceptorProperties.getFieldEncrypt();
        return new MybatisDecryptInterceptor(encryptorManager, fieldEncrypt);
    }

    @Bean
    @Order(value=8)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.data-operate", name={"enabled"}, havingValue="true")
    public DataOperateInterceptor dataOperateInterceptor() {
        return new DataOperateInterceptor();
    }

    @Bean
    @Order(value=9)
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.interceptor.big-result-query", name={"enabled"}, havingValue="true")
    public BigResultQueryInterceptor bigResultQueryInterceptor() {
        MybatisInterceptorProperties.BigResultQuery bigResultQuery = this.interceptorProperties.getBigResultQuery();
        return new BigResultQueryInterceptor(bigResultQuery.getEnabled(), bigResultQuery.getSize());
    }
}

