/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.configuration.MybatisPlusInterceptorAutoConfiguration;
import com.taotao.boot.data.mybatis.mybatisplus.handler.objecthandler.AutoFieldMetaObjectHandler;
import com.taotao.boot.data.mybatis.mybatisplus.handler.typehandler.like.FullLikeTypeHandler;
import com.taotao.boot.data.mybatis.mybatisplus.handler.typehandler.like.LeftLikeTypeHandler;
import com.taotao.boot.data.mybatis.mybatisplus.handler.typehandler.like.RightLikeTypeHandler;
import com.taotao.boot.data.mybatis.mybatisplus.incrementer.SnowFlakeIdGenerator;
import com.taotao.boot.data.mybatis.mybatisplus.injector.MateSqlInjector;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.MpInterceptor;
import com.taotao.boot.data.mybatis.properties.MybatisPlusAutoFillProperties;
import com.taotao.boot.data.mybatis.properties.MybatisPlusProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.type.EnumTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@MapperScan(basePackages={"com.taotao.cloud.*.biz.mapper", "com.taotao.cloud.*.infrastructure.persistent.mapper", "com.taotao.cloud.*.infrastructure.persistent.*.mapper"})
@EnableTransactionManagement
@AutoConfiguration(after={MybatisPlusInterceptorAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusAutoFillProperties.class, MybatisPlusProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MybatisPlusAutoConfiguration
implements InitializingBean {
    private final MybatisPlusAutoFillProperties autoFillProperties;
    private final MybatisPlusProperties mybatisPlusProperties;

    public MybatisPlusAutoConfiguration(MybatisPlusAutoFillProperties autoFillProperties, MybatisPlusProperties mybatisPlusProperties) {
        this.autoFillProperties = autoFillProperties;
        this.mybatisPlusProperties = mybatisPlusProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MybatisPlusAutoConfiguration.class, (String)"taotao-boot-starter-data-mybatis", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus", name={"snowFlakeIdGenerator"}, havingValue="true")
    public IdentifierGenerator identifierGenerator() {
        return new SnowFlakeIdGenerator();
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return new MateSqlInjector();
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(List<MpInterceptor> interceptors) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptors.stream().sorted(Comparator.comparing(MpInterceptor::getSortNo)).map(MpInterceptor::getInnerInterceptor).forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.auto-fill", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AutoFieldMetaObjectHandler metaObjectHandler() {
        return new AutoFieldMetaObjectHandler(this.autoFillProperties);
    }

    @Bean
    public DatabaseIdProvider getDatabaseIdProvider() {
        VendorDatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties properties = new Properties();
        properties.setProperty("Oracle", DbType.ORACLE.getDb());
        properties.setProperty("MySQL", DbType.MYSQL.getDb());
        properties.setProperty("Microsoft SQL Server", DbType.SQL_SERVER.getDb());
        databaseIdProvider.setProperties(properties);
        return databaseIdProvider;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> {
            configuration.setDefaultEnumTypeHandler(EnumTypeHandler.class);
            configuration.setLogPrefix("log.mybatis");
        };
    }

    @Bean
    public LeftLikeTypeHandler getLeftLikeTypeHandler() {
        return new LeftLikeTypeHandler();
    }

    @Bean
    public RightLikeTypeHandler getRightLikeTypeHandler() {
        return new RightLikeTypeHandler();
    }

    @Bean
    public FullLikeTypeHandler getFullLikeTypeHandler() {
        return new FullLikeTypeHandler();
    }
}

