/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.configuration;

import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.MpInterceptor;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datachanage.interceptor.DataChangeRecorderInnerInterceptor;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.datascope.DataScopeInterceptor;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.pagination.SqlPaginationInnerInterceptor;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant.MultiTenantLineHandler;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant.MultiTenantLineInnerInterceptor;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant.MultiTenantType;
import com.taotao.boot.data.mybatis.mybatisplus.interceptor.tenant.SchemaInterceptor;
import com.taotao.boot.data.mybatis.properties.MybatisPlusInterceptorProperties;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={MybatisPlusInterceptorProperties.class})
public class MybatisPlusInterceptorAutoConfiguration
implements InitializingBean {
    private final MybatisPlusInterceptorProperties interceptorProperties;

    public MybatisPlusInterceptorAutoConfiguration(MybatisPlusInterceptorProperties interceptorProperties) {
        this.interceptorProperties = interceptorProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MybatisPlusInterceptorAutoConfiguration.class, (String)"taotao-boot-starter-data-mybatis", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.pagination", name={"enabled"}, havingValue="true")
    public MpInterceptor paginationInnerInterceptor() {
        MybatisPlusInterceptorProperties.Pagination paginationProperties = this.interceptorProperties.getPagination();
        SqlPaginationInnerInterceptor paginationInterceptor = new SqlPaginationInnerInterceptor();
        paginationInterceptor.setMaxLimit(paginationProperties.getMaxLimit());
        paginationInterceptor.setDbType(paginationProperties.getDbType());
        paginationInterceptor.setOverflow(paginationProperties.isOverflow());
        paginationInterceptor.setOptimizeJoin(paginationProperties.isOptimizeJoin());
        return new MpInterceptor((InnerInterceptor)paginationInterceptor, 199);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.block-attack", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public MpInterceptor blockAttackInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor(), 196);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.illegal-sql", name={"enabled"}, havingValue="true")
    public MpInterceptor illegalSqlInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor(), 197);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.optimistic-locker", name={"enabled"}, havingValue="true")
    public MpInterceptor optimisticLockerInnerInterceptor() {
        return new MpInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor(), 198);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.data-scope", name={"enabled"}, havingValue="true")
    public MpInterceptor dataScopeInterceptor() {
        return new MpInterceptor(new DataScopeInterceptor(), 200);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.multi-tenant", name={"enabled"}, havingValue="true")
    public MpInterceptor multiTenantLineInnerInterceptor() {
        MybatisPlusInterceptorProperties.MultiTenant tenantProperties = this.interceptorProperties.getMultiTenant();
        LogUtils.info((String)"\u68c0\u6d4b\u5230 taotao.cloud.data.database.multiTenantType={}\uff0c\u5df2\u542f\u7528 {} \u6a21\u5f0f", (Object[])new Object[]{tenantProperties.getMultiTenantType().name(), tenantProperties.getMultiTenantType().getDescribe()});
        Object innerInterceptor = null;
        if (StrUtil.equalsAny((CharSequence)tenantProperties.getMultiTenantType().name(), (CharSequence[])new CharSequence[]{MultiTenantType.SCHEMA.name(), MultiTenantType.SCHEMA_COLUMN.name()})) {
            innerInterceptor = new SchemaInterceptor(tenantProperties);
        }
        if (StrUtil.equalsAny((CharSequence)tenantProperties.getMultiTenantType().name(), (CharSequence[])new CharSequence[]{MultiTenantType.COLUMN.name(), MultiTenantType.SCHEMA_COLUMN.name(), MultiTenantType.DATASOURCE_COLUMN.name()})) {
            MultiTenantLineHandler multiTenantLineHandler = new MultiTenantLineHandler(tenantProperties);
            innerInterceptor = new MultiTenantLineInnerInterceptor(multiTenantLineHandler, tenantProperties);
        }
        return new MpInterceptor((InnerInterceptor)innerInterceptor, 201);
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.boot.data.mybatis.mybatis-plus.interceptor.data-change", name={"enabled"}, havingValue="true")
    public MpInterceptor dataChangeRecorderInnerInterceptor() {
        return new MpInterceptor(new DataChangeRecorderInnerInterceptor(), 195);
    }
}

