/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.delay;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.delay.AppDelayMessage;
import com.taotao.boot.data.mybatis.delay.AppDelayMessageMapper;
import com.taotao.boot.data.mybatis.delay.AppDelayMessageService;
import com.taotao.boot.data.mybatis.delay.InvokeTimeoutEvent;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppDelayMessageServiceImpl
extends ServiceImpl<AppDelayMessageMapper, AppDelayMessage>
implements AppDelayMessageService,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Async(value="toolThreadPool")
    public void publish(String appId, Integer timeout, AppDelayMessage.Type type, AppDelayMessage.Stage stage, Class callback) {
        LogUtils.info((String)"@@ \u53d1\u5e03\u5ef6\u8fdf\u6d88\u606f, appId:{}, type:{}, stage:{}", (Object[])new Object[]{appId, type, stage});
        AppDelayMessage message = AppDelayMessage.builder().appId(appId).ttl(timeout).type(type).stage(stage).callback(callback.getSimpleName()).build();
        InvokeTimeoutEvent event = new InvokeTimeoutEvent(message);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
    }

    @Override
    @Async(value="toolThreadPool")
    public void callback(AppDelayMessage message) {
        LogUtils.info((String)"@@ \u8d85\u65f6\u56de\u8c03\u51fd\u6570\u5904\u7406, message:{}", (Object[])new Object[]{JSON.toJSONString((Object)message)});
        InvokeTimeoutEvent event = new InvokeTimeoutEvent(message);
        this.eventPublisher.publishEvent((ApplicationEvent)event);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean changeToProcessed(String appId, AppDelayMessage.Stage stage) {
        LogUtils.info((String)"@@ \u4fee\u6539\u5ef6\u8fdf\u6d88\u606f\u72b6\u6001, appId:{}, Stage:{}", (Object[])new Object[]{appId, stage});
        AppDelayMessage one = (AppDelayMessage)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AppDelayMessage::getAppId, (Object)appId)).eq(AppDelayMessage::getStage, (Object)stage)).orderByDesc(AppDelayMessage::getCreateTime)).last("limit 1")).one();
        if (Objects.isNull(one)) {
            return Boolean.TRUE;
        }
        if (AppDelayMessage.Status.TIMEOUT.equals((Object)one.getStatus())) {
            LogUtils.error((String)"@@ \u63a5\u53e3\u8c03\u7528\u8d85\u65f6, \u6d88\u606f\u5185\u5bb9:{}", (Object[])new Object[]{JSON.toJSONString((Object)one)});
            return Boolean.FALSE;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(AppDelayMessage::getStatus, (Object)AppDelayMessage.Status.PROCESSED)).set(AppDelayMessage::getModifyTime, (Object)LocalDateTime.now())).eq(AppDelayMessage::getId, (Object)one.getId())).update();
        return Boolean.TRUE;
    }
}

