/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.delay;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayMessage
implements Delayed {
    private String message;
    private long ttl;

    public DelayMessage(String message, long ttl) {
        this.setMessage(message);
        this.ttl = System.currentTimeMillis() + ttl;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long remaining = this.ttl - System.currentTimeMillis();
        return unit.convert(remaining, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }
}

