/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.delay;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.delay.AppDelayMessage;
import com.taotao.boot.data.mybatis.delay.AppDelayMessageService;
import com.taotao.boot.data.mybatis.delay.DelayMessage;
import java.time.LocalDateTime;
import java.util.concurrent.DelayQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DelayQueueConsumer
implements Runnable {
    private DelayQueue<DelayMessage> delayQueue;
    @Autowired
    private AppDelayMessageService service;

    public void setDelayQueue(DelayQueue<DelayMessage> delayQueue) {
        this.delayQueue = delayQueue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LogUtils.info((String)"@@ \u542f\u52a8\u5f02\u6b65\u7ebf\u7a0b [{}] \u6d88\u8d39\u4ee5\u8d85\u65f6\u7684\u6d88\u606f", (Object[])new Object[]{Thread.currentThread().getName()});
                    DelayMessage delayMessage = (DelayMessage)this.delayQueue.take();
                    AppDelayMessage message = (AppDelayMessage)JSON.parseObject((String)delayMessage.getMessage(), AppDelayMessage.class);
                    this.handleTimeoutError(message);
                    LogUtils.info((String)"@@ \u4ee5\u6d88\u8d39\u6d88\u606f:{}", (Object[])new Object[]{delayMessage.getMessage()});
                }
            }
            catch (InterruptedException e) {
                LogUtils.error((String)"@@ \u7ebf\u7a0b [{}] \u6d88\u8d39\u6d88\u606f\u5f02\u5e38", (Object[])new Object[]{Thread.currentThread().getName(), e});
                continue;
            }
            break;
        }
    }

    @Transactional
    public void handleTimeoutError(AppDelayMessage message) {
        LogUtils.info((String)"@@ \u5904\u7406\u8d85\u65f6\u9519\u8bef, AppDelayMessage:{}", (Object[])new Object[]{message});
        boolean update = ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.service.lambdaUpdate().set(AppDelayMessage::getStatus, (Object)AppDelayMessage.Status.TIMEOUT)).set(AppDelayMessage::getModifyTime, (Object)LocalDateTime.now())).eq(AppDelayMessage::getId, (Object)message.getId())).eq(AppDelayMessage::getStatus, (Object)AppDelayMessage.Status.PENDING)).update();
        if (update) {
            LogUtils.info((String)"@@ \u5904\u7406\u8d85\u65f6\u8c03\u7528\u56de\u8c03\u51fd\u6570, message:{}", (Object[])new Object[]{JSON.toJSONString((Object)message)});
            this.service.callback(message);
        }
    }
}

