/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.delay;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
public class ThreadPoolConfig {
    @Value(value="${import.thread.core}")
    private Integer core;
    @Value(value="${import.thread.max}")
    private Integer max;
    @Value(value="${import.thread.queue}")
    private Integer queue;
    @Value(value="${import.thread.keepAlive}")
    private Integer keepAlive;

    @Bean(value={"toolThreadPool"})
    public ThreadPoolExecutor arxmlThreadPoolExecutor() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("build-tool-%d").build();
        return new ThreadPoolExecutor((int)this.core, (int)this.max, (long)this.keepAlive.intValue(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.queue), namedThreadFactory);
    }
}

