/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.ext.ck;

import com.taotao.boot.data.datasource.ext.ck.ClickHouseDataSourceConfiguration;
import com.taotao.boot.data.mybatis.ext.trino.TrinoMybatisConfiguration;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@AutoConfiguration(after={ClickHouseDataSourceConfiguration.class})
@ConditionalOnBean(value={DataSource.class}, name={"clickHouseDruidDataSource"})
@ConditionalOnProperty(name={"spring.datasource.clickhouse.enabled"}, havingValue="true")
@MapperScan(basePackages={"com.taotao.cloud.*.clickhouse.mapper"}, sqlSessionFactoryRef="clickHouseSqlSessionFactory")
public class ClickHouseMybatisConfiguration {
    private static Logger logger = LoggerFactory.getLogger(TrinoMybatisConfiguration.class);
    private static final String MAPPER_LOCATION = "classpath*:mapper/clickhouse/*.xml";
    private static final String TYPE_ALIASES_PACKAGE = "com.taotao.boot.data.analysis.clickhouse.*";

    @Bean(value={"clickHouseSqlSessionFactory"})
    public SqlSessionFactory clickHouseSqlSessionFactory(@Qualifier(value="clickHouseDruidDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));
        bean.setTypeAliasesPackage(TYPE_ALIASES_PACKAGE);
        return bean.getObject();
    }

    @Bean(value={"clickHouseSqlSessionTemplate"})
    public SqlSessionTemplate clickHouseSqlSessionTemplate(@Qualifier(value="clickHouseSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

