/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.ext.doris;

import com.taotao.boot.data.datasource.ext.doris.DorisDataSourceConfiguration;
import com.taotao.boot.data.mybatis.ext.trino.TrinoMybatisConfiguration;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@AutoConfiguration(after={DorisDataSourceConfiguration.class})
@ConditionalOnBean(value={DataSource.class}, name={"dorisDruidDataSource"})
@ConditionalOnProperty(name={"spring.datasource.doris.enabled"}, havingValue="true")
@MapperScan(basePackages={"com.taotao.cloud.*.doris.mapper"}, sqlSessionFactoryRef="dorisSqlSessionFactory")
public class DorisMybatisConfiguration {
    private static Logger logger = LoggerFactory.getLogger(TrinoMybatisConfiguration.class);
    private static final String MAPPER_LOCATION = "classpath*:mapper/doris/*.xml";
    private static final String TYPE_ALIASES_PACKAGE = "com.taotao.boot.data.analysis.doris.*";

    @Bean(value={"dorisSqlSessionFactory"})
    public SqlSessionFactory dorisSqlSessionFactory(@Qualifier(value="dorisDruidDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MAPPER_LOCATION));
        bean.setTypeAliasesPackage(TYPE_ALIASES_PACKAGE);
        return bean.getObject();
    }

    @Bean(value={"dorisSqlSessionTemplate"})
    public SqlSessionTemplate dorisSqlSessionTemplate(@Qualifier(value="dorisSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

