/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.cipher.util;

import com.taotao.boot.common.utils.log.LogUtils;
import java.math.BigDecimal;
import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class EncryptCodeUtil {
    public static final String BC_PROVIDER_NAME = "BC";
    public static final Provider BC_PROVIDER = new BouncyCastleProvider();
    public static final String KEY = "RoGYxGHUmg+hGgtSaN0O2w==";
    public static final int TIME = 2;
    public static final String AES_ALGORITHM = "AES";

    public static String decryptData(String encryptData) {
        if (encryptData == null) {
            return null;
        }
        return EncryptCodeUtil.decryptAirth(encryptData, KEY, 2);
    }

    public static String encryptData(String decryptdata) {
        if (decryptdata == null) {
            return null;
        }
        return EncryptCodeUtil.encryptAirth(decryptdata, KEY, 2);
    }

    public static String encryptAirth(String data, String base64StringKey, int encryptTime) {
        String str = data;
        if (encryptTime == 0) {
            return str;
        }
        for (int i = 0; i < encryptTime; ++i) {
            str = EncryptCodeUtil.encrypt(str, base64StringKey);
        }
        return str;
    }

    public static String decryptAirth(String encryptData, String base64StringKey, int encryptTime) {
        String str = encryptData;
        if (encryptTime == 0) {
            return str;
        }
        for (int i = 0; i < encryptTime; ++i) {
            str = new String(Objects.requireNonNull(EncryptCodeUtil.decrypt(Base64.decode((String)str), base64StringKey)));
        }
        return str;
    }

    public static String encrypt(String data, String base64StringKey) {
        byte[] encryptData = EncryptCodeUtil.encrypt(data.getBytes(), base64StringKey);
        assert (encryptData != null);
        return Base64.toBase64String((byte[])encryptData);
    }

    public static byte[] encrypt(byte[] data, String base64StringKey) {
        try {
            return EncryptCodeUtil.encrypt(data, Base64.decode((String)base64StringKey));
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM, BC_PROVIDER_NAME);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String decrypt(String encryptData, String base64StringKey) {
        byte[] decryptData = EncryptCodeUtil.decrypt(Base64.decode((String)encryptData), base64StringKey);
        assert (decryptData != null);
        return new String(decryptData);
    }

    public static byte[] decrypt(byte[] data, String base64StringKey) {
        try {
            return EncryptCodeUtil.decrypt(data, Base64.decode((String)base64StringKey));
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM, BC_PROVIDER_NAME);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static String initBase64StringKey() {
        try {
            return Base64.toBase64String((byte[])EncryptCodeUtil.initKey());
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            return null;
        }
    }

    public static byte[] initKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(AES_ALGORITHM, BC_PROVIDER_NAME);
        kg.init(256);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static String encryptNumber(BigDecimal number) {
        return EncryptCodeUtil.encryptString(number.toString());
    }

    public static String encryptString(String str) {
        return EncryptCodeUtil.encryptAirth(str, KEY, 2);
    }

    public static String decryptString(String encryptStr) {
        return EncryptCodeUtil.decryptAirth(encryptStr, KEY, 2);
    }

    public static BigDecimal decryptNumber(String encryptNumber) {
        return new BigDecimal(EncryptCodeUtil.decryptString(encryptNumber));
    }

    static {
        Security.addProvider(BC_PROVIDER);
    }
}

