/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.aspect;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.audit.DataAuditLogging;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.model.UserCache;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.threadlocal.DataOperateLogThreadLocal;
import com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.service.UnifiedProcessingService;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.ibatis.mapping.SqlCommandType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuditLoggingAspect {
    private Logger logger = LoggerFactory.getLogger(AuditLoggingAspect.class);
    @Autowired
    private UnifiedProcessingService unifiedProcessingService;

    @Before(value="@annotation(dataLog)")
    public void beforeDataAuditLogging(JoinPoint joinPoint, DataAuditLogging dataLog) {
        String obj = (String)DataOperateLogThreadLocal.THREADDATA_ID.get();
        if (obj == null) {
            UserCache cache = (UserCache)DataOperateLogThreadLocal.THREADDATA_USER_CACHE.get();
            if (cache != null) {
                obj = cache.getRequestId();
            } else {
                UserCache userCache = new UserCache();
                userCache.setUserId(String.valueOf(UserContextHolder.getUserId()));
                userCache.setUserId(UserContextHolder.getUserName());
                userCache.setRequestId(TraceUtils.getTtcTraceId());
                DataOperateLogThreadLocal.THREADDATA_USER_CACHE.set((Object)userCache);
                obj = userCache.getRequestId();
            }
        }
        DataOperateLogThreadLocal.THREADDATA_ID.set((Object)obj);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String className = methodSignature.getDeclaringTypeName();
        DataOperateLogThreadLocal.THREADDATA_METHOD.set((Object)(className + "#" + joinPoint.getSignature().getName()));
        DataOperateLogThreadLocal.DATA_CHANGES.set(new LinkedList());
        DataOperateLogThreadLocal.JOIN_POINT.set((Object)joinPoint);
        DataOperateLogThreadLocal.DATA_LOG.set((Object)dataLog);
    }

    @AfterReturning(value="@annotation(dataLog)")
    public void afterDataAuditLogging(DataAuditLogging dataLog) {
        try {
            List list = (List)DataOperateLogThreadLocal.DATA_CHANGES.get();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            list.forEach(change -> {
                if (change.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
                    List<?> oldData = change.getOldData();
                    if (CollectionUtils.isEmpty(oldData)) {
                        return;
                    }
                    List maps = change.getJdbcTemplate().query(change.getQuerySql(), (RowMapper)new BeanPropertyRowMapper(change.getEntityType()));
                    change.setNewData(maps);
                }
            });
            this.unifiedProcessingService.compareAndTransfer(list);
        }
        catch (Exception e) {
            this.logger.info("\u6570\u636e\u5ba1\u8ba1\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)e));
        }
    }
}

