/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.interceptor;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.threadlocal.DataOperateLogThreadLocal;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.utils.audit.OperationDataChange;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class})})
public class DataOperateInterceptor
extends JsqlParserSupport
implements Interceptor {
    private final Logger logger = LoggerFactory.getLogger(DataOperateInterceptor.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public Object intercept(Invocation invocation) throws Exception {
        try {
            StatementHandler statementHandler;
            PluginUtils.MPStatementHandler mpSh;
            MappedStatement mappedStatement;
            if (DataOperateLogThreadLocal.DATA_CHANGES.get() == null) {
                return invocation.proceed();
            }
            Object firstArg = invocation.getArgs()[0];
            Statement statement = (Statement)firstArg;
            MetaObject stmtMetaObj = SystemMetaObject.forObject((Object)statement);
            try {
                statement = (Statement)stmtMetaObj.getValue("stmt.statement");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtMetaObj.hasGetter("delegate")) {
                try {
                    statement = (Statement)stmtMetaObj.getValue("delegate");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String originalSql = statement.toString();
            int index = this.indexOfSqlStart(originalSql = originalSql.replaceAll("[\\s]+", " "));
            if (index > 0) {
                originalSql = originalSql.substring(index);
            }
            if ((mappedStatement = (mpSh = PluginUtils.mpStatementHandler((StatementHandler)(statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget())))).mappedStatement()).getSqlCommandType() != null) {
                if (SqlCommandType.UPDATE.equals((Object)mappedStatement.getSqlCommandType())) {
                    Collection tables;
                    String sql = originalSql.replace("where", "WHERE");
                    if (sql.endsWith("]")) {
                        sql = sql.replaceAll("]", "");
                    }
                    if (CollectionUtils.isEmpty((Collection)(tables = new TableNameParser(sql).tables()))) {
                        return invocation.proceed();
                    }
                    String tableName = (String)tables.iterator().next();
                    OperationDataChange change = new OperationDataChange();
                    change.setTableName(tableName);
                    change.setJdbcTemplate(this.jdbcTemplate);
                    String selectSql = sql.substring(sql.lastIndexOf("WHERE") + 5);
                    if (((List)DataOperateLogThreadLocal.DATA_CHANGES.get()).stream().anyMatch(c -> tableName.equals(c.getTableName()) && selectSql.equals(c.getWhereSql()))) {
                        return invocation.proceed();
                    }
                    change.setWhereSql(selectSql);
                    Object parameterObject = statementHandler.getParameterHandler().getParameterObject();
                    change.setTransferData(Collections.singletonList(parameterObject));
                    String querySql = "select * from " + tableName + " where " + selectSql;
                    change.setQuerySql(querySql);
                    List maps = this.jdbcTemplate.query(querySql, (RowMapper)new BeanPropertyRowMapper(parameterObject.getClass()));
                    change.setOldData(maps);
                    change.setEntityType(parameterObject.getClass());
                    change.setSqlCommandType(mappedStatement.getSqlCommandType());
                    ((List)DataOperateLogThreadLocal.DATA_CHANGES.get()).add(change);
                }
                if (SqlCommandType.INSERT.equals((Object)mappedStatement.getSqlCommandType()) || SqlCommandType.DELETE.equals((Object)mappedStatement.getSqlCommandType())) {
                    OperationDataChange change = new OperationDataChange();
                    change.setSqlCommandType(mappedStatement.getSqlCommandType());
                    change.setQuerySql(originalSql);
                    ((List)DataOperateLogThreadLocal.DATA_CHANGES.get()).add(change);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("DataOperateInterceptor-intercept-error:{}", (Object)JSON.toJSONString((Object)e));
        }
        return invocation.proceed();
    }

    private int indexOfSqlStart(String sql) {
        String upperCaseSql = sql.toUpperCase();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(upperCaseSql.indexOf("SELECT "));
        set.add(upperCaseSql.indexOf("UPDATE "));
        set.add(upperCaseSql.indexOf("INSERT "));
        set.add(upperCaseSql.indexOf("DELETE "));
        set.remove(-1);
        if (CollectionUtils.isEmpty(set)) {
            return -1;
        }
        ArrayList list = new ArrayList(set);
        list.sort(Comparator.naturalOrder());
        return (Integer)list.get(0);
    }
}

