/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.service;

import com.alibaba.fastjson2.JSON;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.model.UserCache;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.threadlocal.DataOperateLogThreadLocal;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.utils.UUIDUtils;
import com.taotao.boot.data.mybatis.interceptor.easylog.common.utils.audit.OperationDataChange;
import com.taotao.boot.data.mybatis.interceptor.easylog.dataaudit.model.MongoDataAuditRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UnifiedProcessingService {
    private Logger logger = LoggerFactory.getLogger(UnifiedProcessingService.class);
    private final String openapiUrl = "http://MongoDB\u670d\u52a1/";

    @Async
    public void compareAndTransfer(List<OperationDataChange> list) {
        ArrayList saveData = new ArrayList();
        list.forEach(change -> {
            if (change.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
                List<?> oldData = change.getOldData();
                List<?> newData = change.getNewData();
                if (newData == null) {
                    return;
                }
                if (oldData == null) {
                    return;
                }
                if (oldData.size() != newData.size()) {
                    return;
                }
                for (int i = 0; i < oldData.size(); ++i) {
                    try {
                        saveData.add(new MongoDataAuditRecord().converterMongoDataAuditRecord((OperationDataChange)change, oldData.get(i), newData.get(i)));
                        continue;
                    }
                    catch (Exception e) {
                        LogUtils.error((Throwable)e);
                    }
                }
            } else {
                MongoDataAuditRecord record = new MongoDataAuditRecord();
                record.setNewObject(change.getQuerySql());
                record.setOperatorId(((UserCache)DataOperateLogThreadLocal.THREADDATA_USER_CACHE.get()).getUserId());
                record.setBusinessProcessId((String)DataOperateLogThreadLocal.THREADDATA_ID.get());
                record.setId(UUIDUtils.getStringUUID());
                record.setBusinessCallMethod((String)DataOperateLogThreadLocal.THREADDATA_METHOD.get());
                record.setCreateTime(new Date());
                record.setSqlCommandType(change.getSqlCommandType());
                saveData.add(record);
            }
        });
        if (!CollectionUtils.isEmpty(saveData)) {
            this.batchAddOperateLog(saveData);
        }
        DataOperateLogThreadLocal.transfer();
    }

    public void batchAddOperateLog(List<?> list) {
        try {
            LogUtils.info((String)"\u53d8\u66f4\u6570\u636e---> {}", (Object[])new Object[]{list});
        }
        catch (Exception e) {
            this.logger.info("\u6570\u636e\u5ba1\u8ba1\u8bb0\u5f55\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)e));
        }
    }
}

