/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.core;

import com.taotao.boot.data.mybatis.interceptor.encrypt.annotation.EncryptField;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.IEncryptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.dromara.hutool.core.reflect.ConstructorUtil;

public class EncryptorManager {
    Map<EncryptContext, IEncryptor> encryptorMap = new ConcurrentHashMap<EncryptContext, IEncryptor>();
    Map<Class<?>, Set<Field>> fieldCache = new ConcurrentHashMap();

    public Set<Field> getFieldCache(Class<?> sourceClazz) {
        return this.fieldCache.computeIfAbsent(sourceClazz, clazz -> {
            Field[] declaredFields = clazz.getDeclaredFields();
            Set fieldSet = Arrays.stream(declaredFields).filter(field -> field.isAnnotationPresent(EncryptField.class) && field.getType() == String.class).collect(Collectors.toSet());
            for (Field field2 : fieldSet) {
                field2.setAccessible(true);
            }
            return fieldSet;
        });
    }

    public IEncryptor registAndGetEncryptor(EncryptContext encryptContext) {
        if (this.encryptorMap.containsKey(encryptContext)) {
            return this.encryptorMap.get(encryptContext);
        }
        IEncryptor encryptor = (IEncryptor)ConstructorUtil.newInstance(encryptContext.getAlgorithm().getClazz(), (Object[])new Object[]{encryptContext});
        this.encryptorMap.put(encryptContext, encryptor);
        return encryptor;
    }

    public void removeEncryptor(EncryptContext encryptContext) {
        this.encryptorMap.remove(encryptContext);
    }

    public String encrypt(String value, EncryptContext encryptContext) {
        IEncryptor encryptor = this.registAndGetEncryptor(encryptContext);
        return encryptor.encrypt(value, encryptContext.getEncode());
    }

    public String decrypt(String value, EncryptContext encryptContext) {
        IEncryptor encryptor = this.registAndGetEncryptor(encryptContext);
        return encryptor.decrypt(value);
    }
}

