/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor;

import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor.AbstractEncryptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.AlgorithmType;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.EncodeType;
import java.nio.charset.StandardCharsets;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.symmetric.AES;

public class AesEncryptor
extends AbstractEncryptor {
    private final AES aes;

    public AesEncryptor(EncryptContext context) {
        super(context);
        String password = context.getPassword();
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("AES\u6ca1\u6709\u83b7\u5f97\u79d8\u94a5\u4fe1\u606f");
        }
        int[] array = new int[]{16, 24, 32};
        if (!ArrayUtil.contains((int[])array, (int)password.length())) {
            throw new IllegalArgumentException("AES\u79d8\u94a5\u957f\u5ea6\u5e94\u8be5\u4e3a16\u4f4d\u300124\u4f4d\u300132\u4f4d\uff0c\u5b9e\u9645\u4e3a" + password.length() + "\u4f4d");
        }
        this.aes = SecureUtil.aes((byte[])context.getPassword().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.AES;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return this.aes.encryptHex(value);
        }
        return this.aes.encryptBase64(value);
    }

    @Override
    public String decrypt(String value) {
        return this.aes.decryptStr(value);
    }
}

