/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor;

import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor.AbstractEncryptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.AlgorithmType;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.EncodeType;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.RSA;

public class RsaEncryptor
extends AbstractEncryptor {
    private final RSA rsa;

    public RsaEncryptor(EncryptContext context) {
        super(context);
        String privateKey = context.getPrivateKey();
        String publicKey = context.getPublicKey();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{privateKey, publicKey})) {
            throw new IllegalArgumentException("RSA\u516c\u79c1\u94a5\u5747\u9700\u8981\u63d0\u4f9b\uff0c\u516c\u94a5\u52a0\u5bc6\uff0c\u79c1\u94a5\u89e3\u5bc6\u3002");
        }
        this.rsa = SecureUtil.rsa((byte[])Base64.decode((CharSequence)privateKey), (byte[])Base64.decode((CharSequence)publicKey));
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.RSA;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return this.rsa.encryptHex(value, KeyType.PublicKey);
        }
        return this.rsa.encryptBase64(value, KeyType.PublicKey);
    }

    @Override
    public String decrypt(String value) {
        return this.rsa.decryptStr(value, KeyType.PrivateKey);
    }
}

