/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor;

import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor.AbstractEncryptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.AlgorithmType;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.EncodeType;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.SM2;
import org.dromara.hutool.crypto.bc.SmUtil;

public class Sm2Encryptor
extends AbstractEncryptor {
    private final SM2 sm2;

    public Sm2Encryptor(EncryptContext context) {
        super(context);
        String privateKey = context.getPrivateKey();
        String publicKey = context.getPublicKey();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{privateKey, publicKey})) {
            throw new IllegalArgumentException("SM2\u516c\u79c1\u94a5\u5747\u9700\u8981\u63d0\u4f9b\uff0c\u516c\u94a5\u52a0\u5bc6\uff0c\u79c1\u94a5\u89e3\u5bc6\u3002");
        }
        this.sm2 = SmUtil.sm2((byte[])Base64.decode((CharSequence)privateKey), (byte[])Base64.decode((CharSequence)publicKey));
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.SM2;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return this.sm2.encryptHex(value, KeyType.PublicKey);
        }
        return this.sm2.encryptBase64(value, KeyType.PublicKey);
    }

    @Override
    public String decrypt(String value) {
        return this.sm2.decryptStr(value, KeyType.PrivateKey);
    }
}

