/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor;

import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.encryptor.AbstractEncryptor;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.AlgorithmType;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.EncodeType;
import java.nio.charset.StandardCharsets;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.bc.SmUtil;
import org.dromara.hutool.crypto.symmetric.SM4;

public class Sm4Encryptor
extends AbstractEncryptor {
    private final SM4 sm4;

    public Sm4Encryptor(EncryptContext context) {
        super(context);
        String password = context.getPassword();
        if (StrUtil.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("SM4\u6ca1\u6709\u83b7\u5f97\u79d8\u94a5\u4fe1\u606f");
        }
        if (16 != password.length()) {
            throw new IllegalArgumentException("SM4\u79d8\u94a5\u957f\u5ea6\u5e94\u8be5\u4e3a16\u4f4d\uff0c\u5b9e\u9645\u4e3a" + password.length() + "\u4f4d");
        }
        this.sm4 = SmUtil.sm4((byte[])password.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public AlgorithmType algorithm() {
        return AlgorithmType.SM4;
    }

    @Override
    public String encrypt(String value, EncodeType encodeType) {
        if (encodeType == EncodeType.HEX) {
            return this.sm4.encryptHex(value);
        }
        return this.sm4.encryptBase64(value);
    }

    @Override
    public String decrypt(String value) {
        return this.sm4.decryptStr(value);
    }
}

