/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.encrypt.interceptor;

import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.encrypt.annotation.EncryptField;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptContext;
import com.taotao.boot.data.mybatis.interceptor.encrypt.core.EncryptorManager;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.AlgorithmType;
import com.taotao.boot.data.mybatis.interceptor.encrypt.enumd.EncodeType;
import com.taotao.boot.data.mybatis.properties.MybatisInterceptorProperties;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.util.ObjUtil;

@Intercepts(value={@Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class MybatisEncryptInterceptor
implements Interceptor {
    private final EncryptorManager encryptorManager;
    private final MybatisInterceptorProperties.FieldEncrypt defaultProperties;

    public MybatisEncryptInterceptor(EncryptorManager encryptorManager, MybatisInterceptorProperties.FieldEncrypt defaultProperties) {
        this.encryptorManager = encryptorManager;
        this.defaultProperties = defaultProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return invocation;
    }

    public Object plugin(Object target) {
        ParameterHandler parameterHandler;
        Object parameterObject;
        if (target instanceof ParameterHandler && ObjUtil.isNotNull((Object)(parameterObject = (parameterHandler = (ParameterHandler)target).getParameterObject())) && !(parameterObject instanceof String)) {
            this.encryptHandler(parameterObject);
        }
        return target;
    }

    private void encryptHandler(Object sourceObject) {
        if (ObjUtil.isNull((Object)sourceObject)) {
            return;
        }
        if (sourceObject instanceof Map) {
            new HashSet(((Map)sourceObject).values()).forEach(this::encryptHandler);
            return;
        }
        if (sourceObject instanceof List) {
            List sourceList = (List)sourceObject;
            if (CollUtil.isEmpty((Collection)sourceList)) {
                return;
            }
            Object firstItem = sourceList.get(0);
            if (CollUtil.isEmpty(this.encryptorManager.getFieldCache(firstItem.getClass()))) {
                return;
            }
            ((List)sourceObject).forEach(this::encryptHandler);
            return;
        }
        Set<Field> fields = this.encryptorManager.getFieldCache(sourceObject.getClass());
        try {
            for (Field field : fields) {
                field.set(sourceObject, this.encryptField(String.valueOf(field.get(sourceObject)), field));
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u65f6\u51fa\u9519", (Object[])new Object[]{e});
        }
    }

    private String encryptField(String value, Field field) {
        EncryptField encryptField = field.getAnnotation(EncryptField.class);
        EncryptContext encryptContext = new EncryptContext();
        encryptContext.setAlgorithm(encryptField.algorithm() == AlgorithmType.DEFAULT ? this.defaultProperties.getAlgorithm() : encryptField.algorithm());
        encryptContext.setEncode(encryptField.encode() == EncodeType.DEFAULT ? this.defaultProperties.getEncode() : encryptField.encode());
        encryptContext.setPassword(StringUtils.isBlank((String)encryptField.password()) ? this.defaultProperties.getPassword() : encryptField.password());
        encryptContext.setPrivateKey(StringUtils.isBlank((String)encryptField.privateKey()) ? this.defaultProperties.getPrivateKey() : encryptField.privateKey());
        encryptContext.setPublicKey(StringUtils.isBlank((String)encryptField.publicKey()) ? this.defaultProperties.getPublicKey() : encryptField.publicKey());
        return this.encryptorManager.encrypt(value, encryptContext);
    }

    public void setProperties(Properties properties) {
    }
}

