/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.data.mybatis.interceptor.log.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.data.mybatis.interceptor.log.interceptor.ActualSqlInterceptor;
import com.taotao.boot.data.mybatis.interceptor.log.properties.ActualSqlProperties;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={ActualSqlProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
@Configuration
@Lazy(value=false)
@Order
public class ActualSqlConfiguration
implements InitializingBean {
    @Autowired
    ActualSqlProperties actualSqlProperties;
    @Autowired
    List<SqlSessionFactory> sqlSessionFactoryList;

    public void afterPropertiesSet() throws Exception {
        ActualSqlInterceptor interceptor = new ActualSqlInterceptor();
        Properties properties = new Properties();
        properties.put("", this.actualSqlProperties);
        interceptor.setProperties(properties);
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
            if (ActualSqlConfiguration.isInterceptorExists(configuration, interceptor)) continue;
            configuration.addInterceptor((Interceptor)interceptor);
        }
        ActualSqlConfiguration.printGraph();
    }

    private static boolean isInterceptorExists(org.apache.ibatis.session.Configuration configuration, Interceptor interceptor) {
        try {
            return configuration.getInterceptors().contains(interceptor);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void printGraph() {
        LogUtils.info((String)"                                                                          \n  ,---.          ,--.                  ,--.     ,---.   ,-----.   ,--.    \n /  O  \\  ,---.,-'  '-.,--.,--. ,--,--.|  |    '   .-' '  .-.  '  |  |    \n|  .-.  || .--''-.  .-'|  ||  |' ,-.  ||  |    `.  `-. |  | |  |  |  |    \n|  | |  |\\ `--.  |  |  '  ''  '\\ '-'  ||  |    .-'    |'  '-'  '-.|  '--. \n`--' `--' `---'  `--'   `----'  `--`--'`--'    `-----'  `-----'--'`-----' \n                                                                          ", (Object[])new Object[0]);
    }
}

